/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.types;

import de.flapdoodle.types.ThrowingConsumer;
import de.flapdoodle.types.ThrowingFunction;
import de.flapdoodle.types.ThrowingSupplier;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class Optionals {
    public static <S, D, E extends Exception> Optional<D> map(Optional<S> source, ThrowingFunction<? super S, ? extends D, E> mapper) throws E {
        return source.isPresent() ? Optional.of(mapper.apply(source.get())) : Optional.empty();
    }

    public static <D, E extends Exception> D orElseGet(Optional<D> current, ThrowingSupplier<? extends D, E> supplier) throws E {
        return current.isPresent() ? current.get() : supplier.get();
    }

    public static <T> Wrapper<T> wrap(Optional<T> wrapped) {
        return new Wrapper<T>(wrapped);
    }

    public static class Wrapper<T> {
        private final Optional<T> wrapped;

        public Wrapper(Optional<T> wrapped) {
            this.wrapped = wrapped;
        }

        public T get() {
            return this.wrapped.get();
        }

        public boolean isPresent() {
            return this.wrapped.isPresent();
        }

        public <E extends Exception> void ifPresent(Consumer<? super T> consumer) {
            this.wrapped.ifPresent(consumer);
        }

        public <E extends Exception> void ifPresent(ThrowingConsumer<? super T, E> consumer) throws E {
            if (this.wrapped.isPresent()) {
                consumer.accept(this.wrapped.get());
            }
        }

        public Wrapper<T> filter(Predicate<? super T> predicate) {
            return Optionals.wrap(this.wrapped.filter(predicate));
        }

        public <U, E extends Exception> Wrapper<U> map(ThrowingFunction<? super T, ? extends U, E> mapper) throws E {
            return Optionals.wrap(Optionals.map(this.wrapped, mapper));
        }

        public <U, E extends Exception> Wrapper<U> flatMap(ThrowingFunction<? super T, Optional<U>, E> mapper) throws E {
            Optional<Optional<U>> mapped = Optionals.map(this.wrapped, mapper);
            return Optionals.wrap(mapped.isPresent() ? mapped.get() : Optional.empty());
        }

        public T orElse(T other) {
            return this.wrapped.orElse(other);
        }

        public <E extends Exception> T orElseGet(ThrowingSupplier<? extends T, E> supplier) throws E {
            return Optionals.orElseGet(this.wrapped, supplier);
        }

        public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
            return this.wrapped.orElseThrow(exceptionSupplier);
        }

        public boolean equals(Object obj) {
            return obj.getClass() == this.getClass() && this.wrapped.equals(obj);
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        public String toString() {
            return "Wrapped(" + this.wrapped.toString() + ")";
        }
    }
}

