/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.types;

import java.util.function.BiFunction;
import java.util.function.Function;

public interface ThrowingFunction<T, R, E extends Exception> {
    public R apply(T var1) throws E;

    default public <N extends Exception> ThrowingFunction<T, R, N> mapCheckedException(Function<Exception, N> exceptionMapper) {
        return value -> {
            try {
                return this.apply(value);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw (Exception)exceptionMapper.apply(e);
            }
        };
    }

    default public Function<T, R> onCheckedException(BiFunction<Exception, T, R> exceptionToFallback) {
        return value -> {
            try {
                return this.apply(value);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                return exceptionToFallback.apply(e, value);
            }
        };
    }
}

