/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.types;

import java.util.function.Function;
import java.util.function.Supplier;

public interface ThrowingSupplier<T, E extends Exception> {
    public T get() throws E;

    default public <N extends Exception> ThrowingSupplier<T, N> mapCheckedException(Function<Exception, N> exceptionMapper) {
        return () -> {
            try {
                return this.get();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw (Exception)exceptionMapper.apply(e);
            }
        };
    }

    default public Supplier<T> onCheckedException(Function<Exception, T> exceptionToFallback) {
        return () -> {
            try {
                return this.get();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                return exceptionToFallback.apply(e);
            }
        };
    }
}

