/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.types;

import de.flapdoodle.types.ImmutableEither;
import java.util.Optional;
import java.util.function.Function;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Either<L, R> {
    protected abstract Optional<L> optLeft();

    protected abstract Optional<R> optRight();

    @Value.Auxiliary
    public boolean isLeft() {
        return this.optLeft().isPresent();
    }

    @Value.Auxiliary
    public L left() {
        return this.optLeft().get();
    }

    @Value.Auxiliary
    public R right() {
        return this.optRight().get();
    }

    public <T> Either<T, R> mapLeft(Function<L, T> transformation) {
        return this.isLeft() ? Either.left(transformation.apply(this.left())) : this;
    }

    public <T> Either<L, T> mapRight(Function<R, T> transformation) {
        return this.isLeft() ? this : Either.right(transformation.apply(this.right()));
    }

    public <T> T map(Function<L, T> leftTransformation, Function<R, T> rightTransformation) {
        Either<T, T> mapped = this.mapLeft(leftTransformation).mapRight(rightTransformation);
        return mapped.isLeft() ? mapped.left() : mapped.right();
    }

    @Value.Check
    protected void check() {
        if (this.optLeft().isPresent() && this.optRight().isPresent()) {
            throw new IllegalArgumentException("is both: " + this.optLeft() + "," + this.optRight());
        }
        if (!this.optLeft().isPresent() && !this.optRight().isPresent()) {
            throw new IllegalArgumentException("is nothing");
        }
    }

    public static <L, R> Either<L, R> left(L left) {
        return ImmutableEither.builder().optLeft(left).build();
    }

    public static <L, R> Either<L, R> right(R right) {
        return ImmutableEither.builder().optRight(right).build();
    }
}

