/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.types;

import de.flapdoodle.types.Either;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="Either", generator="Immutables")
public final class ImmutableEither<L, R>
extends Either<L, R> {
    private final L optLeft;
    private final R optRight;

    private ImmutableEither(L optLeft, R optRight) {
        this.optLeft = optLeft;
        this.optRight = optRight;
    }

    @Override
    protected Optional<L> optLeft() {
        return Optional.ofNullable(this.optLeft);
    }

    @Override
    protected Optional<R> optRight() {
        return Optional.ofNullable(this.optRight);
    }

    public final ImmutableEither<L, R> withOptLeft(L value) {
        L newValue = Objects.requireNonNull(value, "optLeft");
        if (this.optLeft == newValue) {
            return this;
        }
        return ImmutableEither.validate(new ImmutableEither<L, R>(newValue, this.optRight));
    }

    public final ImmutableEither<L, R> withOptLeft(Optional<? extends L> optional) {
        L value = optional.orElse(null);
        if (this.optLeft == value) {
            return this;
        }
        return ImmutableEither.validate(new ImmutableEither<Object, R>(value, this.optRight));
    }

    public final ImmutableEither<L, R> withOptRight(R value) {
        R newValue = Objects.requireNonNull(value, "optRight");
        if (this.optRight == newValue) {
            return this;
        }
        return ImmutableEither.validate(new ImmutableEither<L, R>(this.optLeft, newValue));
    }

    public final ImmutableEither<L, R> withOptRight(Optional<? extends R> optional) {
        R value = optional.orElse(null);
        if (this.optRight == value) {
            return this;
        }
        return ImmutableEither.validate(new ImmutableEither<L, Object>(this.optLeft, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEither && this.equalTo((ImmutableEither)another);
    }

    private boolean equalTo(ImmutableEither<?, ?> another) {
        return Objects.equals(this.optLeft, another.optLeft) && Objects.equals(this.optRight, another.optRight);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.optLeft);
        h += (h << 5) + Objects.hashCode(this.optRight);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Either{");
        if (this.optLeft != null) {
            builder.append("optLeft=").append(this.optLeft);
        }
        if (this.optRight != null) {
            if (builder.length() > 7) {
                builder.append(", ");
            }
            builder.append("optRight=").append(this.optRight);
        }
        return builder.append("}").toString();
    }

    private static <L, R> ImmutableEither<L, R> validate(ImmutableEither<L, R> instance) {
        instance.check();
        return instance;
    }

    public static <L, R> ImmutableEither<L, R> copyOf(Either<L, R> instance) {
        if (instance instanceof ImmutableEither) {
            return (ImmutableEither)instance;
        }
        return ImmutableEither.builder().from(instance).build();
    }

    public static <L, R> Builder<L, R> builder() {
        return new Builder();
    }

    @Generated(from="Either", generator="Immutables")
    public static final class Builder<L, R> {
        private L optLeft;
        private R optRight;

        private Builder() {
        }

        public final Builder<L, R> from(Either<L, R> instance) {
            Optional<R> optRightOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<L> optLeftOptional = instance.optLeft();
            if (optLeftOptional.isPresent()) {
                this.optLeft(optLeftOptional);
            }
            if ((optRightOptional = instance.optRight()).isPresent()) {
                this.optRight(optRightOptional);
            }
            return this;
        }

        public final Builder<L, R> optLeft(L optLeft) {
            this.optLeft = Objects.requireNonNull(optLeft, "optLeft");
            return this;
        }

        public final Builder<L, R> optLeft(Optional<? extends L> optLeft) {
            this.optLeft = optLeft.orElse(null);
            return this;
        }

        public final Builder<L, R> optRight(R optRight) {
            this.optRight = Objects.requireNonNull(optRight, "optRight");
            return this;
        }

        public final Builder<L, R> optRight(Optional<? extends R> optRight) {
            this.optRight = optRight.orElse(null);
            return this;
        }

        public ImmutableEither<L, R> build() {
            return ImmutableEither.validate(new ImmutableEither(this.optLeft, this.optRight));
        }
    }
}

