package de.flapdoodle.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Pair}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePair.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutablePair.of()}.
 */
@Generated(from = "Pair", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutablePair<FIRST, SECOND> extends Pair<FIRST, SECOND> {
  private final FIRST first;
  private final SECOND second;

  private ImmutablePair(FIRST first, SECOND second) {
    this.first = Objects.requireNonNull(first, "first");
    this.second = Objects.requireNonNull(second, "second");
  }

  private ImmutablePair(ImmutablePair<FIRST, SECOND> original, FIRST first, SECOND second) {
    this.first = first;
    this.second = second;
  }

  /**
   * @return The value of the {@code first} attribute
   */
  @Override
  public FIRST first() {
    return first;
  }

  /**
   * @return The value of the {@code second} attribute
   */
  @Override
  public SECOND second() {
    return second;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Pair#first() first} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for first
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePair<FIRST, SECOND> withFirst(FIRST value) {
    if (this.first == value) return this;
    FIRST newValue = Objects.requireNonNull(value, "first");
    return new ImmutablePair<>(this, newValue, this.second);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Pair#second() second} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for second
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePair<FIRST, SECOND> withSecond(SECOND value) {
    if (this.second == value) return this;
    SECOND newValue = Objects.requireNonNull(value, "second");
    return new ImmutablePair<>(this, this.first, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePair} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePair<?, ?>
        && equalTo((ImmutablePair<?, ?>) another);
  }

  private boolean equalTo(ImmutablePair<?, ?> another) {
    return first.equals(another.first)
        && second.equals(another.second);
  }

  /**
   * Computes a hash code from attributes: {@code first}, {@code second}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + first.hashCode();
    h += (h << 5) + second.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Pair} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Pair{"
        + "first=" + first
        + ", second=" + second
        + "}";
  }

  /**
   * Construct a new immutable {@code Pair} instance.
 * @param <FIRST> generic parameter FIRST
 * @param <SECOND> generic parameter SECOND
   * @param first The value for the {@code first} attribute
   * @param second The value for the {@code second} attribute
   * @return An immutable Pair instance
   */
  public static <FIRST, SECOND> ImmutablePair<FIRST, SECOND> of(FIRST first, SECOND second) {
    return new ImmutablePair<>(first, second);
  }

  /**
   * Creates an immutable copy of a {@link Pair} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <FIRST> generic parameter FIRST
   * @param <SECOND> generic parameter SECOND
   * @param instance The instance to copy
   * @return A copied immutable Pair instance
   */
  public static <FIRST, SECOND> ImmutablePair<FIRST, SECOND> copyOf(Pair<FIRST, SECOND> instance) {
    if (instance instanceof ImmutablePair<?, ?>) {
      return (ImmutablePair<FIRST, SECOND>) instance;
    }
    return ImmutablePair.<FIRST, SECOND>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePair ImmutablePair}.
   * <pre>
   * ImmutablePair.&amp;lt;FIRST, SECOND&amp;gt;builder()
   *    .first(FIRST) // required {@link Pair#first() first}
   *    .second(SECOND) // required {@link Pair#second() second}
   *    .build();
   * </pre>
   * @param <FIRST> generic parameter FIRST
   * @param <SECOND> generic parameter SECOND
   * @return A new ImmutablePair builder
   */
  public static <FIRST, SECOND> ImmutablePair.Builder<FIRST, SECOND> builder() {
    return new ImmutablePair.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutablePair ImmutablePair}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Pair", generator = "Immutables")
  public static final class Builder<FIRST, SECOND> {
    private static final long INIT_BIT_FIRST = 0x1L;
    private static final long INIT_BIT_SECOND = 0x2L;
    private long initBits = 0x3L;

    private FIRST first;
    private SECOND second;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Pair} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<FIRST, SECOND> from(Pair<FIRST, SECOND> instance) {
      Objects.requireNonNull(instance, "instance");
      first(instance.first());
      second(instance.second());
      return this;
    }

    /**
     * Initializes the value for the {@link Pair#first() first} attribute.
     * @param first The value for first 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<FIRST, SECOND> first(FIRST first) {
      this.first = Objects.requireNonNull(first, "first");
      initBits &= ~INIT_BIT_FIRST;
      return this;
    }

    /**
     * Initializes the value for the {@link Pair#second() second} attribute.
     * @param second The value for second 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<FIRST, SECOND> second(SECOND second) {
      this.second = Objects.requireNonNull(second, "second");
      initBits &= ~INIT_BIT_SECOND;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePair ImmutablePair}.
     * @return An immutable instance of Pair
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePair<FIRST, SECOND> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePair<>(null, first, second);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FIRST) != 0) attributes.add("first");
      if ((initBits & INIT_BIT_SECOND) != 0) attributes.add("second");
      return "Cannot build Pair, some of required attributes are not set " + attributes;
    }
  }
}
