/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.streams;

import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class ZipStream {
    private ZipStream() {
    }

    public static <L, R, Z> Stream<Z> of(Stream<L> left, Stream<R> right, BiFunction<L, R, Z> combiner) {
        return StreamSupport.stream(ZipSpliterator.zipping(left.spliterator(), right.spliterator(), combiner), false);
    }

    static class ZipSpliterator<L, R, O>
    implements Spliterator<O> {
        private final Spliterator<L> lefts;
        private final Spliterator<R> rights;
        private final BiFunction<L, R, O> combiner;
        private boolean rightHadNext = false;

        static <L, R, O> Spliterator<O> zipping(Spliterator<L> lefts, Spliterator<R> rights, BiFunction<L, R, O> combiner) {
            return new ZipSpliterator<L, R, O>(lefts, rights, combiner);
        }

        private ZipSpliterator(Spliterator<L> lefts, Spliterator<R> rights, BiFunction<L, R, O> combiner) {
            this.lefts = lefts;
            this.rights = rights;
            this.combiner = combiner;
        }

        @Override
        public boolean tryAdvance(Consumer<? super O> action) {
            this.rightHadNext = false;
            boolean leftHadNext = this.lefts.tryAdvance((? super T l) -> this.rights.tryAdvance((? super T r) -> {
                this.rightHadNext = true;
                action.accept((O)this.combiner.apply(l, r));
            }));
            return leftHadNext && this.rightHadNext;
        }

        @Override
        public Spliterator<O> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Math.min(this.lefts.estimateSize(), this.rights.estimateSize());
        }

        @Override
        public int characteristics() {
            return this.lefts.characteristics() & this.rights.characteristics() & 0xFFFFFFFA;
        }
    }
}

