/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.types;

import java.util.function.Function;

public interface ThrowingRunnable<E extends Exception> {
    public void run() throws E;

    default public <N extends Exception> ThrowingRunnable<N> mapCheckedException(Function<Exception, N> exceptionMapper) {
        return () -> {
            try {
                this.run();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw (Exception)exceptionMapper.apply(e);
            }
        };
    }

    default public ThrowingRunnable<E> andFinally(Runnable runnable) {
        return () -> {
            try {
                this.run();
            }
            finally {
                runnable.run();
            }
        };
    }
}

