/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.types;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface ThrowingFunction<T, R, E extends Exception> {
    public R apply(T var1) throws E;

    default public <N extends Exception> ThrowingFunction<T, R, N> mapException(Function<Exception, N> exceptionMapper) {
        return value -> {
            try {
                return this.apply(value);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw (Exception)exceptionMapper.apply(e);
            }
        };
    }

    default public Function<T, R> mapToUncheckedException(Function<Exception, RuntimeException> exceptionMapper) {
        return this.mapException(exceptionMapper)::apply;
    }

    default public ThrowingFunction<T, R, E> andFinally(Runnable runnable) {
        return value -> {
            try {
                R r = this.apply(value);
                return r;
            }
            finally {
                runnable.run();
            }
        };
    }

    default public Function<T, R> fallbackTo(BiFunction<Exception, T, R> exceptionToFallback) {
        return value -> {
            try {
                return this.apply(value);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                return exceptionToFallback.apply(e, value);
            }
        };
    }

    default public Function<T, Optional<R>> onCheckedException(BiConsumer<Exception, T> onException) {
        return value -> {
            try {
                return Optional.of(this.apply(value));
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                onException.accept(e, value);
                return Optional.empty();
            }
        };
    }
}

