/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reflection;

import de.flapdoodle.reflection.ClassTypeInfo;
import de.flapdoodle.reflection.ListTypeInfo;
import de.flapdoodle.reflection.MapTypeInfo;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.immutables.value.Value;

public interface TypeInfo<T> {
    @Value.Auxiliary
    public T cast(Object var1);

    @Value.Auxiliary
    public boolean isInstance(Object var1);

    @Value.Auxiliary
    public boolean isAssignable(TypeInfo<?> var1);

    @Value.Auxiliary
    default public Optional<T> ifInstance(Object instance) {
        return this.isInstance(instance) ? Optional.of(instance) : Optional.empty();
    }

    public static <T> TypeInfo<T> of(Class<T> type) {
        return ClassTypeInfo.of(type);
    }

    public static <T> TypeInfo<List<T>> listOf(TypeInfo<T> type) {
        return ListTypeInfo.of(type);
    }

    public static <K, V> TypeInfo<Map<K, V>> mapOf(TypeInfo<K> key, TypeInfo<V> value) {
        return MapTypeInfo.of(key, value);
    }
}

