package de.flapdoodle.net;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProxyFactory.HostnamePortProxyFactory}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHostnamePortProxyFactory.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableHostnamePortProxyFactory.of()}.
 */
@Generated(from = "ProxyFactory.HostnamePortProxyFactory", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableHostnamePortProxyFactory
    extends ProxyFactory.HostnamePortProxyFactory {
  private final String hostName;
  private final int port;

  private ImmutableHostnamePortProxyFactory(String hostName, int port) {
    this.hostName = Objects.requireNonNull(hostName, "hostName");
    this.port = port;
  }

  private ImmutableHostnamePortProxyFactory(ImmutableHostnamePortProxyFactory original, String hostName, int port) {
    this.hostName = hostName;
    this.port = port;
  }

  /**
   * @return The value of the {@code hostName} attribute
   */
  @Override
  public String hostName() {
    return hostName;
  }

  /**
   * @return The value of the {@code port} attribute
   */
  @Override
  public int port() {
    return port;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProxyFactory.HostnamePortProxyFactory#hostName() hostName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hostName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostnamePortProxyFactory withHostName(String value) {
    String newValue = Objects.requireNonNull(value, "hostName");
    if (this.hostName.equals(newValue)) return this;
    return new ImmutableHostnamePortProxyFactory(this, newValue, this.port);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProxyFactory.HostnamePortProxyFactory#port() port} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for port
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHostnamePortProxyFactory withPort(int value) {
    if (this.port == value) return this;
    return new ImmutableHostnamePortProxyFactory(this, this.hostName, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHostnamePortProxyFactory} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHostnamePortProxyFactory
        && equalTo(0, (ImmutableHostnamePortProxyFactory) another);
  }

  private boolean equalTo(int synthetic, ImmutableHostnamePortProxyFactory another) {
    return hostName.equals(another.hostName)
        && port == another.port;
  }

  /**
   * Computes a hash code from attributes: {@code hostName}, {@code port}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + hostName.hashCode();
    h += (h << 5) + port;
    return h;
  }

  /**
   * Prints the immutable value {@code HostnamePortProxyFactory} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "HostnamePortProxyFactory{"
        + "hostName=" + hostName
        + ", port=" + port
        + "}";
  }

  /**
   * Construct a new immutable {@code HostnamePortProxyFactory} instance.
   * @param hostName The value for the {@code hostName} attribute
   * @param port The value for the {@code port} attribute
   * @return An immutable HostnamePortProxyFactory instance
   */
  public static ImmutableHostnamePortProxyFactory of(String hostName, int port) {
    return new ImmutableHostnamePortProxyFactory(hostName, port);
  }

  /**
   * Creates an immutable copy of a {@link ProxyFactory.HostnamePortProxyFactory} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HostnamePortProxyFactory instance
   */
  public static ImmutableHostnamePortProxyFactory copyOf(ProxyFactory.HostnamePortProxyFactory instance) {
    if (instance instanceof ImmutableHostnamePortProxyFactory) {
      return (ImmutableHostnamePortProxyFactory) instance;
    }
    return ImmutableHostnamePortProxyFactory.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHostnamePortProxyFactory ImmutableHostnamePortProxyFactory}.
   * <pre>
   * ImmutableHostnamePortProxyFactory.builder()
   *    .hostName(String) // required {@link ProxyFactory.HostnamePortProxyFactory#hostName() hostName}
   *    .port(int) // required {@link ProxyFactory.HostnamePortProxyFactory#port() port}
   *    .build();
   * </pre>
   * @return A new ImmutableHostnamePortProxyFactory builder
   */
  public static ImmutableHostnamePortProxyFactory.Builder builder() {
    return new ImmutableHostnamePortProxyFactory.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHostnamePortProxyFactory ImmutableHostnamePortProxyFactory}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProxyFactory.HostnamePortProxyFactory", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_HOST_NAME = 0x1L;
    private static final long INIT_BIT_PORT = 0x2L;
    private long initBits = 0x3L;

    private String hostName;
    private int port;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HostnamePortProxyFactory} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProxyFactory.HostnamePortProxyFactory instance) {
      Objects.requireNonNull(instance, "instance");
      this.hostName(instance.hostName());
      this.port(instance.port());
      return this;
    }

    /**
     * Initializes the value for the {@link ProxyFactory.HostnamePortProxyFactory#hostName() hostName} attribute.
     * @param hostName The value for hostName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hostName(String hostName) {
      this.hostName = Objects.requireNonNull(hostName, "hostName");
      initBits &= ~INIT_BIT_HOST_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ProxyFactory.HostnamePortProxyFactory#port() port} attribute.
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(int port) {
      this.port = port;
      initBits &= ~INIT_BIT_PORT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableHostnamePortProxyFactory ImmutableHostnamePortProxyFactory}.
     * @return An immutable instance of HostnamePortProxyFactory
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHostnamePortProxyFactory build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHostnamePortProxyFactory(null, hostName, port);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_HOST_NAME) != 0) attributes.add("hostName");
      if ((initBits & INIT_BIT_PORT) != 0) attributes.add("port");
      return "Cannot build HostnamePortProxyFactory, some of required attributes are not set " + attributes;
    }
  }
}
