package de.flapdoodle.transition;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link NamedType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNamedType.<T>builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableNamedType.<T>of()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "NamedType<T>"})
public final class ImmutableNamedType<T> implements NamedType<T> {
  private final String name;
  private final Type type;

  private ImmutableNamedType(String name, Type type) {
    this.name = Objects.requireNonNull(name, "name");
    this.type = Objects.requireNonNull(type, "type");
  }

  private ImmutableNamedType(ImmutableNamedType original, String name, Type type) {
    this.name = name;
    this.type = type;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public Type type() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NamedType#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNamedType<T> withName(String value) {
    if (this.name.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "name");
    return new ImmutableNamedType<T>(this, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NamedType#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNamedType<T> withType(Type value) {
    if (this.type == value) return this;
    Type newValue = Objects.requireNonNull(value, "type");
    return new ImmutableNamedType<T>(this, this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNamedType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @SuppressWarnings("unchecked")
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNamedType<?>
        && equalTo((ImmutableNamedType<T>) another);
  }

  private boolean equalTo(ImmutableNamedType<T> another) {
    return name.equals(another.name)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NamedType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NamedType{"
        + "name=" + name
        + ", type=" + type
        + "}";
  }

  /**
   * Construct a new immutable {@code NamedType} instance.
   * @param name The value for the {@code name} attribute
   * @param type The value for the {@code type} attribute
   * @return An immutable NamedType instance
   */
  public static <T> ImmutableNamedType<T> of(String name, Type type) {
    return new ImmutableNamedType<T>(name, type);
  }

  /**
   * Creates an immutable copy of a {@link NamedType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable NamedType instance
   */
  public static <T> ImmutableNamedType<T> copyOf(NamedType<T> instance) {
    if (instance instanceof ImmutableNamedType<?>) {
      return (ImmutableNamedType<T>) instance;
    }
    return ImmutableNamedType.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNamedType ImmutableNamedType}.
   * @param <T> generic parameter T
   * @return A new ImmutableNamedType builder
   */
  public static <T> ImmutableNamedType.Builder<T> builder() {
    return new ImmutableNamedType.Builder<T>();
  }

  /**
   * Builds instances of type {@link ImmutableNamedType ImmutableNamedType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder<T> {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private Type type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NamedType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(NamedType<T> instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      type(instance.type());
      return this;
    }

    /**
     * Initializes the value for the {@link NamedType#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link NamedType#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> type(Type type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNamedType ImmutableNamedType}.
     * @return An immutable instance of NamedType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNamedType<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNamedType<T>(null, name, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build NamedType, some of required attributes are not set " + attributes;
    }
  }
}
