package de.flapdoodle.transition.initlike;

import de.flapdoodle.transition.NamedType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link InitListener.Simple}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSimple.builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "InitListener.Simple"})
public final class ImmutableSimple extends InitListener.Simple {
  private final BiConsumer<NamedType<?>, Object> onStateReached;
  private final BiConsumer<NamedType<?>, Object> onTearDown;

  private ImmutableSimple(
      BiConsumer<NamedType<?>, Object> onStateReached,
      BiConsumer<NamedType<?>, Object> onTearDown) {
    this.onStateReached = onStateReached;
    this.onTearDown = onTearDown;
  }

  /**
   * @return The value of the {@code onStateReached} attribute
   */
  @Override
  protected Optional<BiConsumer<NamedType<?>, Object>> onStateReached() {
    return Optional.ofNullable(onStateReached);
  }

  /**
   * @return The value of the {@code onTearDown} attribute
   */
  @Override
  protected Optional<BiConsumer<NamedType<?>, Object>> onTearDown() {
    return Optional.ofNullable(onTearDown);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link InitListener.Simple#onStateReached() onStateReached} attribute.
   * @param value The value for onStateReached
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSimple withOnStateReached(BiConsumer<NamedType<?>, Object> value) {
    BiConsumer<NamedType<?>, Object> newValue = Objects.requireNonNull(value, "onStateReached");
    if (this.onStateReached == newValue) return this;
    return new ImmutableSimple(newValue, this.onTearDown);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link InitListener.Simple#onStateReached() onStateReached} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for onStateReached
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSimple withOnStateReached(Optional<BiConsumer<NamedType<?>, Object>> optional) {
    BiConsumer<NamedType<?>, Object> value = optional.orElse(null);
    if (this.onStateReached == value) return this;
    return new ImmutableSimple(value, this.onTearDown);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link InitListener.Simple#onTearDown() onTearDown} attribute.
   * @param value The value for onTearDown
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSimple withOnTearDown(BiConsumer<NamedType<?>, Object> value) {
    BiConsumer<NamedType<?>, Object> newValue = Objects.requireNonNull(value, "onTearDown");
    if (this.onTearDown == newValue) return this;
    return new ImmutableSimple(this.onStateReached, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link InitListener.Simple#onTearDown() onTearDown} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for onTearDown
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSimple withOnTearDown(Optional<BiConsumer<NamedType<?>, Object>> optional) {
    BiConsumer<NamedType<?>, Object> value = optional.orElse(null);
    if (this.onTearDown == value) return this;
    return new ImmutableSimple(this.onStateReached, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSimple} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSimple
        && equalTo((ImmutableSimple) another);
  }

  private boolean equalTo(ImmutableSimple another) {
    return Objects.equals(onStateReached, another.onStateReached)
        && Objects.equals(onTearDown, another.onTearDown);
  }

  /**
   * Computes a hash code from attributes: {@code onStateReached}, {@code onTearDown}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(onStateReached);
    h = h * 17 + Objects.hashCode(onTearDown);
    return h;
  }

  /**
   * Prints the immutable value {@code Simple} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Simple{");
    if (onStateReached != null) {
      builder.append("onStateReached=").append(onStateReached);
    }
    if (onTearDown != null) {
      if (builder.length() > 7) builder.append(", ");
      builder.append("onTearDown=").append(onTearDown);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link InitListener.Simple} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Simple instance
   */
  public static ImmutableSimple copyOf(InitListener.Simple instance) {
    if (instance instanceof ImmutableSimple) {
      return (ImmutableSimple) instance;
    }
    return ImmutableSimple.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSimple ImmutableSimple}.
   * @return A new ImmutableSimple builder
   */
  public static ImmutableSimple.Builder builder() {
    return new ImmutableSimple.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSimple ImmutableSimple}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private BiConsumer<NamedType<?>, Object> onStateReached;
    private BiConsumer<NamedType<?>, Object> onTearDown;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Simple} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InitListener.Simple instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<BiConsumer<NamedType<?>, Object>> onStateReachedOptional = instance.onStateReached();
      if (onStateReachedOptional.isPresent()) {
        onStateReached(onStateReachedOptional);
      }
      Optional<BiConsumer<NamedType<?>, Object>> onTearDownOptional = instance.onTearDown();
      if (onTearDownOptional.isPresent()) {
        onTearDown(onTearDownOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link InitListener.Simple#onStateReached() onStateReached} to onStateReached.
     * @param onStateReached The value for onStateReached
     * @return {@code this} builder for chained invocation
     */
    public final Builder onStateReached(BiConsumer<NamedType<?>, Object> onStateReached) {
      this.onStateReached = Objects.requireNonNull(onStateReached, "onStateReached");
      return this;
    }

    /**
     * Initializes the optional value {@link InitListener.Simple#onStateReached() onStateReached} to onStateReached.
     * @param onStateReached The value for onStateReached
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder onStateReached(Optional<BiConsumer<NamedType<?>, Object>> onStateReached) {
      this.onStateReached = onStateReached.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link InitListener.Simple#onTearDown() onTearDown} to onTearDown.
     * @param onTearDown The value for onTearDown
     * @return {@code this} builder for chained invocation
     */
    public final Builder onTearDown(BiConsumer<NamedType<?>, Object> onTearDown) {
      this.onTearDown = Objects.requireNonNull(onTearDown, "onTearDown");
      return this;
    }

    /**
     * Initializes the optional value {@link InitListener.Simple#onTearDown() onTearDown} to onTearDown.
     * @param onTearDown The value for onTearDown
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder onTearDown(Optional<BiConsumer<NamedType<?>, Object>> onTearDown) {
      this.onTearDown = onTearDown.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSimple ImmutableSimple}.
     * @return An immutable instance of Simple
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSimple build() {
      return new ImmutableSimple(onStateReached, onTearDown);
    }
  }
}
