package de.flapdoodle.transition.routes;

import de.flapdoodle.transition.NamedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link End}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEnd.<S>builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "End<S>"})
public final class ImmutableEnd<S> implements End<S> {
  private final NamedType<S> start;

  private ImmutableEnd(NamedType<S> start) {
    this.start = start;
  }

  /**
   * @return The value of the {@code start} attribute
   */
  @Override
  public NamedType<S> start() {
    return start;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link End#start() start} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for start
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnd<S> withStart(NamedType<S> value) {
    if (this.start == value) return this;
    NamedType<S> newValue = Objects.requireNonNull(value, "start");
    return new ImmutableEnd<S>(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEnd} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @SuppressWarnings("unchecked")
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEnd<?>
        && equalTo((ImmutableEnd<S>) another);
  }

  private boolean equalTo(ImmutableEnd<S> another) {
    return start.equals(another.start);
  }

  /**
   * Computes a hash code from attributes: {@code start}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + start.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code End} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "End{"
        + "start=" + start
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link End} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <S> generic parameter S
   * @param instance The instance to copy
   * @return A copied immutable End instance
   */
  public static <S> ImmutableEnd<S> copyOf(End<S> instance) {
    if (instance instanceof ImmutableEnd<?>) {
      return (ImmutableEnd<S>) instance;
    }
    return ImmutableEnd.<S>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEnd ImmutableEnd}.
   * @param <S> generic parameter S
   * @return A new ImmutableEnd builder
   */
  public static <S> ImmutableEnd.Builder<S> builder() {
    return new ImmutableEnd.Builder<S>();
  }

  /**
   * Builds instances of type {@link ImmutableEnd ImmutableEnd}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder<S> {
    private static final long INIT_BIT_START = 0x1L;
    private long initBits = 0x1L;

    private NamedType<S> start;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code End} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S> from(End<S> instance) {
      Objects.requireNonNull(instance, "instance");
      start(instance.start());
      return this;
    }

    /**
     * Initializes the value for the {@link End#start() start} attribute.
     * @param start The value for start 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S> start(NamedType<S> start) {
      this.start = Objects.requireNonNull(start, "start");
      initBits &= ~INIT_BIT_START;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEnd ImmutableEnd}.
     * @return An immutable instance of End
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEnd<S> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEnd<S>(start);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_START) != 0) attributes.add("start");
      return "Cannot build End, some of required attributes are not set " + attributes;
    }
  }
}
