package de.flapdoodle.transition.routes;

import de.flapdoodle.transition.NamedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link MergingJunction}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMergingJunction.<L, R, D>builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "MergingJunction<L, R, D>"})
public final class ImmutableMergingJunction<L, R, D>
    implements MergingJunction<L, R, D> {
  private final NamedType<L> left;
  private final NamedType<R> right;
  private final NamedType<D> destination;

  private ImmutableMergingJunction(
      NamedType<L> left,
      NamedType<R> right,
      NamedType<D> destination) {
    this.left = left;
    this.right = right;
    this.destination = destination;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public NamedType<L> left() {
    return left;
  }

  /**
   * @return The value of the {@code right} attribute
   */
  @Override
  public NamedType<R> right() {
    return right;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public NamedType<D> destination() {
    return destination;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MergingJunction#left() left} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMergingJunction<L, R, D> withLeft(NamedType<L> value) {
    if (this.left == value) return this;
    NamedType<L> newValue = Objects.requireNonNull(value, "left");
    return new ImmutableMergingJunction<L, R, D>(newValue, this.right, this.destination);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MergingJunction#right() right} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for right
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMergingJunction<L, R, D> withRight(NamedType<R> value) {
    if (this.right == value) return this;
    NamedType<R> newValue = Objects.requireNonNull(value, "right");
    return new ImmutableMergingJunction<L, R, D>(this.left, newValue, this.destination);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MergingJunction#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMergingJunction<L, R, D> withDestination(NamedType<D> value) {
    if (this.destination == value) return this;
    NamedType<D> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableMergingJunction<L, R, D>(this.left, this.right, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMergingJunction} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @SuppressWarnings("unchecked")
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMergingJunction<?, ?, ?>
        && equalTo((ImmutableMergingJunction<L, R, D>) another);
  }

  private boolean equalTo(ImmutableMergingJunction<L, R, D> another) {
    return left.equals(another.left)
        && right.equals(another.right)
        && destination.equals(another.destination);
  }

  /**
   * Computes a hash code from attributes: {@code left}, {@code right}, {@code destination}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + left.hashCode();
    h = h * 17 + right.hashCode();
    h = h * 17 + destination.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MergingJunction} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MergingJunction{"
        + "left=" + left
        + ", right=" + right
        + ", destination=" + destination
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MergingJunction} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @param <D> generic parameter D
   * @param instance The instance to copy
   * @return A copied immutable MergingJunction instance
   */
  public static <L, R, D> ImmutableMergingJunction<L, R, D> copyOf(MergingJunction<L, R, D> instance) {
    if (instance instanceof ImmutableMergingJunction<?, ?, ?>) {
      return (ImmutableMergingJunction<L, R, D>) instance;
    }
    return ImmutableMergingJunction.<L, R, D>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMergingJunction ImmutableMergingJunction}.
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @param <D> generic parameter D
   * @param destination {@code destination} parameter
   * @return A new ImmutableMergingJunction builder
   */
  public static <L, R, D> ImmutableMergingJunction.Builder<L, R, D> builder(NamedType<D> destination) {
    return new ImmutableMergingJunction.Builder<L, R, D>(destination);
  }

  static <L, R, D> ImmutableMergingJunction.Builder<L, R, D> builder() {
    return new ImmutableMergingJunction.Builder<L, R, D>();
  }

  /**
   * Builds instances of type {@link ImmutableMergingJunction ImmutableMergingJunction}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder<L, R, D> {
    private static final long INIT_BIT_LEFT = 0x1L;
    private static final long INIT_BIT_RIGHT = 0x2L;
    private static final long INIT_BIT_DESTINATION = 0x4L;
    private long initBits = 0x7L;

    private NamedType<L> left;
    private NamedType<R> right;
    private NamedType<D> destination;

    private Builder(NamedType<D> destination) {
      destination(destination);
    }

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MergingJunction} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> from(MergingJunction<L, R, D> instance) {
      Objects.requireNonNull(instance, "instance");
      left(instance.left());
      right(instance.right());
      destination(instance.destination());
      return this;
    }

    /**
     * Initializes the value for the {@link MergingJunction#left() left} attribute.
     * @param left The value for left 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> left(NamedType<L> left) {
      this.left = Objects.requireNonNull(left, "left");
      initBits &= ~INIT_BIT_LEFT;
      return this;
    }

    /**
     * Initializes the value for the {@link MergingJunction#right() right} attribute.
     * @param right The value for right 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> right(NamedType<R> right) {
      this.right = Objects.requireNonNull(right, "right");
      initBits &= ~INIT_BIT_RIGHT;
      return this;
    }

    /**
     * Initializes the value for the {@link MergingJunction#destination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder<L, R, D> destination(NamedType<D> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMergingJunction ImmutableMergingJunction}.
     * @return An immutable instance of MergingJunction
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMergingJunction<L, R, D> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMergingJunction<L, R, D>(left, right, destination);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_LEFT) != 0) attributes.add("left");
      if ((initBits & INIT_BIT_RIGHT) != 0) attributes.add("right");
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      return "Cannot build MergingJunction, some of required attributes are not set " + attributes;
    }
  }
}
