package de.flapdoodle.transition.routes;

import de.flapdoodle.transition.NamedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Start}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStart.<D>builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "Start<D>"})
public final class ImmutableStart<D> implements Start<D> {
  private final NamedType<D> destination;

  private ImmutableStart(NamedType<D> destination) {
    this.destination = destination;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public NamedType<D> destination() {
    return destination;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Start#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStart<D> withDestination(NamedType<D> value) {
    if (this.destination == value) return this;
    NamedType<D> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableStart<D>(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStart} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @SuppressWarnings("unchecked")
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStart<?>
        && equalTo((ImmutableStart<D>) another);
  }

  private boolean equalTo(ImmutableStart<D> another) {
    return destination.equals(another.destination);
  }

  /**
   * Computes a hash code from attributes: {@code destination}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + destination.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Start} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Start{"
        + "destination=" + destination
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Start} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <D> generic parameter D
   * @param instance The instance to copy
   * @return A copied immutable Start instance
   */
  public static <D> ImmutableStart<D> copyOf(Start<D> instance) {
    if (instance instanceof ImmutableStart<?>) {
      return (ImmutableStart<D>) instance;
    }
    return ImmutableStart.<D>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStart ImmutableStart}.
   * @param <D> generic parameter D
   * @param destination {@code destination} parameter
   * @return A new ImmutableStart builder
   */
  public static <D> ImmutableStart.Builder<D> builder(NamedType<D> destination) {
    return new ImmutableStart.Builder<D>(destination);
  }

  static <D> ImmutableStart.Builder<D> builder() {
    return new ImmutableStart.Builder<D>();
  }

  /**
   * Builds instances of type {@link ImmutableStart ImmutableStart}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder<D> {
    private static final long INIT_BIT_DESTINATION = 0x1L;
    private long initBits = 0x1L;

    private NamedType<D> destination;

    private Builder(NamedType<D> destination) {
      destination(destination);
    }

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Start} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<D> from(Start<D> instance) {
      Objects.requireNonNull(instance, "instance");
      destination(instance.destination());
      return this;
    }

    /**
     * Initializes the value for the {@link Start#destination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder<D> destination(NamedType<D> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStart ImmutableStart}.
     * @return An immutable instance of Start
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStart<D> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStart<D>(destination);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      return "Cannot build Start, some of required attributes are not set " + attributes;
    }
  }
}
