package de.flapdoodle.transition.routes;

import de.flapdoodle.transition.NamedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link ThreeWayMergingJunction}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableThreeWayMergingJunction.<L, M, R, D>builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "ThreeWayMergingJunction<L, M, R, D>"})
public final class ImmutableThreeWayMergingJunction<L, M, R, D>
    implements ThreeWayMergingJunction<L, M, R, D> {
  private final NamedType<L> left;
  private final NamedType<M> middle;
  private final NamedType<R> right;
  private final NamedType<D> destination;

  private ImmutableThreeWayMergingJunction(
      NamedType<L> left,
      NamedType<M> middle,
      NamedType<R> right,
      NamedType<D> destination) {
    this.left = left;
    this.middle = middle;
    this.right = right;
    this.destination = destination;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public NamedType<L> left() {
    return left;
  }

  /**
   * @return The value of the {@code middle} attribute
   */
  @Override
  public NamedType<M> middle() {
    return middle;
  }

  /**
   * @return The value of the {@code right} attribute
   */
  @Override
  public NamedType<R> right() {
    return right;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public NamedType<D> destination() {
    return destination;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ThreeWayMergingJunction#left() left} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableThreeWayMergingJunction<L, M, R, D> withLeft(NamedType<L> value) {
    if (this.left == value) return this;
    NamedType<L> newValue = Objects.requireNonNull(value, "left");
    return new ImmutableThreeWayMergingJunction<L, M, R, D>(newValue, this.middle, this.right, this.destination);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ThreeWayMergingJunction#middle() middle} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for middle
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableThreeWayMergingJunction<L, M, R, D> withMiddle(NamedType<M> value) {
    if (this.middle == value) return this;
    NamedType<M> newValue = Objects.requireNonNull(value, "middle");
    return new ImmutableThreeWayMergingJunction<L, M, R, D>(this.left, newValue, this.right, this.destination);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ThreeWayMergingJunction#right() right} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for right
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableThreeWayMergingJunction<L, M, R, D> withRight(NamedType<R> value) {
    if (this.right == value) return this;
    NamedType<R> newValue = Objects.requireNonNull(value, "right");
    return new ImmutableThreeWayMergingJunction<L, M, R, D>(this.left, this.middle, newValue, this.destination);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ThreeWayMergingJunction#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableThreeWayMergingJunction<L, M, R, D> withDestination(NamedType<D> value) {
    if (this.destination == value) return this;
    NamedType<D> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableThreeWayMergingJunction<L, M, R, D>(this.left, this.middle, this.right, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableThreeWayMergingJunction} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @SuppressWarnings("unchecked")
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableThreeWayMergingJunction<?, ?, ?, ?>
        && equalTo((ImmutableThreeWayMergingJunction<L, M, R, D>) another);
  }

  private boolean equalTo(ImmutableThreeWayMergingJunction<L, M, R, D> another) {
    return left.equals(another.left)
        && middle.equals(another.middle)
        && right.equals(another.right)
        && destination.equals(another.destination);
  }

  /**
   * Computes a hash code from attributes: {@code left}, {@code middle}, {@code right}, {@code destination}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + left.hashCode();
    h = h * 17 + middle.hashCode();
    h = h * 17 + right.hashCode();
    h = h * 17 + destination.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ThreeWayMergingJunction} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ThreeWayMergingJunction{"
        + "left=" + left
        + ", middle=" + middle
        + ", right=" + right
        + ", destination=" + destination
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ThreeWayMergingJunction} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <L> generic parameter L
   * @param <M> generic parameter M
   * @param <R> generic parameter R
   * @param <D> generic parameter D
   * @param instance The instance to copy
   * @return A copied immutable ThreeWayMergingJunction instance
   */
  public static <L, M, R, D> ImmutableThreeWayMergingJunction<L, M, R, D> copyOf(ThreeWayMergingJunction<L, M, R, D> instance) {
    if (instance instanceof ImmutableThreeWayMergingJunction<?, ?, ?, ?>) {
      return (ImmutableThreeWayMergingJunction<L, M, R, D>) instance;
    }
    return ImmutableThreeWayMergingJunction.<L, M, R, D>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableThreeWayMergingJunction ImmutableThreeWayMergingJunction}.
   * @param <L> generic parameter L
   * @param <M> generic parameter M
   * @param <R> generic parameter R
   * @param <D> generic parameter D
   * @param destination {@code destination} parameter
   * @return A new ImmutableThreeWayMergingJunction builder
   */
  public static <L, M, R, D> ImmutableThreeWayMergingJunction.Builder<L, M, R, D> builder(NamedType<D> destination) {
    return new ImmutableThreeWayMergingJunction.Builder<L, M, R, D>(destination);
  }

  static <L, M, R, D> ImmutableThreeWayMergingJunction.Builder<L, M, R, D> builder() {
    return new ImmutableThreeWayMergingJunction.Builder<L, M, R, D>();
  }

  /**
   * Builds instances of type {@link ImmutableThreeWayMergingJunction ImmutableThreeWayMergingJunction}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder<L, M, R, D> {
    private static final long INIT_BIT_LEFT = 0x1L;
    private static final long INIT_BIT_MIDDLE = 0x2L;
    private static final long INIT_BIT_RIGHT = 0x4L;
    private static final long INIT_BIT_DESTINATION = 0x8L;
    private long initBits = 0xfL;

    private NamedType<L> left;
    private NamedType<M> middle;
    private NamedType<R> right;
    private NamedType<D> destination;

    private Builder(NamedType<D> destination) {
      destination(destination);
    }

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ThreeWayMergingJunction} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, M, R, D> from(ThreeWayMergingJunction<L, M, R, D> instance) {
      Objects.requireNonNull(instance, "instance");
      left(instance.left());
      middle(instance.middle());
      right(instance.right());
      destination(instance.destination());
      return this;
    }

    /**
     * Initializes the value for the {@link ThreeWayMergingJunction#left() left} attribute.
     * @param left The value for left 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, M, R, D> left(NamedType<L> left) {
      this.left = Objects.requireNonNull(left, "left");
      initBits &= ~INIT_BIT_LEFT;
      return this;
    }

    /**
     * Initializes the value for the {@link ThreeWayMergingJunction#middle() middle} attribute.
     * @param middle The value for middle 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, M, R, D> middle(NamedType<M> middle) {
      this.middle = Objects.requireNonNull(middle, "middle");
      initBits &= ~INIT_BIT_MIDDLE;
      return this;
    }

    /**
     * Initializes the value for the {@link ThreeWayMergingJunction#right() right} attribute.
     * @param right The value for right 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, M, R, D> right(NamedType<R> right) {
      this.right = Objects.requireNonNull(right, "right");
      initBits &= ~INIT_BIT_RIGHT;
      return this;
    }

    /**
     * Initializes the value for the {@link ThreeWayMergingJunction#destination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder<L, M, R, D> destination(NamedType<D> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableThreeWayMergingJunction ImmutableThreeWayMergingJunction}.
     * @return An immutable instance of ThreeWayMergingJunction
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableThreeWayMergingJunction<L, M, R, D> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableThreeWayMergingJunction<L, M, R, D>(left, middle, right, destination);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_LEFT) != 0) attributes.add("left");
      if ((initBits & INIT_BIT_MIDDLE) != 0) attributes.add("middle");
      if ((initBits & INIT_BIT_RIGHT) != 0) attributes.add("right");
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      return "Cannot build ThreeWayMergingJunction, some of required attributes are not set " + attributes;
    }
  }
}
