package de.flapdoodle.transition.initlike.edges;

import de.flapdoodle.transition.StateID;
import de.flapdoodle.transition.initlike.State;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Merge2}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMerge2.builder()}.
 */
@Generated(from = "Merge2", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableMerge2<L, R, D> implements Merge2<L, R, D> {
  private final StateID<L> left;
  private final StateID<R> right;
  private final StateID<D> destination;
  private final BiFunction<L, R, State<D>> action;

  private ImmutableMerge2(
      StateID<L> left,
      StateID<R> right,
      StateID<D> destination,
      BiFunction<L, R, State<D>> action) {
    this.left = left;
    this.right = right;
    this.destination = destination;
    this.action = action;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public StateID<L> left() {
    return left;
  }

  /**
   * @return The value of the {@code right} attribute
   */
  @Override
  public StateID<R> right() {
    return right;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public StateID<D> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @Override
  public BiFunction<L, R, State<D>> action() {
    return action;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge2#left() left} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge2<L, R, D> withLeft(StateID<L> value) {
    if (this.left == value) return this;
    StateID<L> newValue = Objects.requireNonNull(value, "left");
    return new ImmutableMerge2<>(newValue, this.right, this.destination, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge2#right() right} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for right
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge2<L, R, D> withRight(StateID<R> value) {
    if (this.right == value) return this;
    StateID<R> newValue = Objects.requireNonNull(value, "right");
    return new ImmutableMerge2<>(this.left, newValue, this.destination, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge2#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge2<L, R, D> withDestination(StateID<D> value) {
    if (this.destination == value) return this;
    StateID<D> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableMerge2<>(this.left, this.right, newValue, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge2#action() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge2<L, R, D> withAction(BiFunction<L, R, State<D>> value) {
    if (this.action == value) return this;
    BiFunction<L, R, State<D>> newValue = Objects.requireNonNull(value, "action");
    return new ImmutableMerge2<>(this.left, this.right, this.destination, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMerge2} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMerge2<?, ?, ?>
        && equalTo((ImmutableMerge2<?, ?, ?>) another);
  }

  private boolean equalTo(ImmutableMerge2<?, ?, ?> another) {
    return left.equals(another.left)
        && right.equals(another.right)
        && destination.equals(another.destination)
        && action.equals(another.action);
  }

  /**
   * Computes a hash code from attributes: {@code left}, {@code right}, {@code destination}, {@code action}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + left.hashCode();
    h += (h << 5) + right.hashCode();
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + action.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Merge2} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Merge2{"
        + "left=" + left
        + ", right=" + right
        + ", destination=" + destination
        + ", action=" + action
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Merge2} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @param <D> generic parameter D
   * @param instance The instance to copy
   * @return A copied immutable Merge2 instance
   */
  public static <L, R, D> ImmutableMerge2<L, R, D> copyOf(Merge2<L, R, D> instance) {
    if (instance instanceof ImmutableMerge2<?, ?, ?>) {
      return (ImmutableMerge2<L, R, D>) instance;
    }
    return ImmutableMerge2.<L, R, D>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMerge2 ImmutableMerge2}.
   * <pre>
   * ImmutableMerge2.&amp;lt;L, R, D&amp;gt;builder()
   *    .left(de.flapdoodle.transition.StateID&amp;lt;L&amp;gt;) // required {@link Merge2#left() left}
   *    .right(de.flapdoodle.transition.StateID&amp;lt;R&amp;gt;) // required {@link Merge2#right() right}
   *    .destination(de.flapdoodle.transition.StateID&amp;lt;D&amp;gt;) // required {@link Merge2#destination() destination}
   *    .action(function.BiFunction&amp;lt;L, R, de.flapdoodle.transition.initlike.State&amp;lt;D&amp;gt;&amp;gt;) // required {@link Merge2#action() action}
   *    .build();
   * </pre>
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @param <D> generic parameter D
   * @return A new ImmutableMerge2 builder
   */
  public static <L, R, D> ImmutableMerge2.Builder<L, R, D> builder() {
    return new ImmutableMerge2.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableMerge2 ImmutableMerge2}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Merge2", generator = "Immutables")
  public static final class Builder<L, R, D> {
    private static final long INIT_BIT_LEFT = 0x1L;
    private static final long INIT_BIT_RIGHT = 0x2L;
    private static final long INIT_BIT_DESTINATION = 0x4L;
    private static final long INIT_BIT_ACTION = 0x8L;
    private long initBits = 0xfL;

    private StateID<L> left;
    private StateID<R> right;
    private StateID<D> destination;
    private BiFunction<L, R, State<D>> action;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Merge2} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> from(Merge2<L, R, D> instance) {
      Objects.requireNonNull(instance, "instance");
      left(instance.left());
      right(instance.right());
      destination(instance.destination());
      action(instance.action());
      return this;
    }

    /**
     * Initializes the value for the {@link Merge2#left() left} attribute.
     * @param left The value for left 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> left(StateID<L> left) {
      this.left = Objects.requireNonNull(left, "left");
      initBits &= ~INIT_BIT_LEFT;
      return this;
    }

    /**
     * Initializes the value for the {@link Merge2#right() right} attribute.
     * @param right The value for right 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> right(StateID<R> right) {
      this.right = Objects.requireNonNull(right, "right");
      initBits &= ~INIT_BIT_RIGHT;
      return this;
    }

    /**
     * Initializes the value for the {@link Merge2#destination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> destination(StateID<D> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link Merge2#action() action} attribute.
     * @param action The value for action 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> action(BiFunction<L, R, State<D>> action) {
      this.action = Objects.requireNonNull(action, "action");
      initBits &= ~INIT_BIT_ACTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMerge2 ImmutableMerge2}.
     * @return An immutable instance of Merge2
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMerge2<L, R, D> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMerge2<>(left, right, destination, action);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LEFT) != 0) attributes.add("left");
      if ((initBits & INIT_BIT_RIGHT) != 0) attributes.add("right");
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      if ((initBits & INIT_BIT_ACTION) != 0) attributes.add("action");
      return "Cannot build Merge2, some of required attributes are not set " + attributes;
    }
  }
}
