package de.flapdoodle.transition.processlike;

import de.flapdoodle.transition.StateID;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link State}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableState.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableState.of()}.
 */
@Generated(from = "State", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableState<T> implements State<T> {
  private final StateID<T> type;
  private final T value;

  private ImmutableState(StateID<T> type, T value) {
    this.type = Objects.requireNonNull(type, "type");
    this.value = Objects.requireNonNull(value, "value");
  }

  private ImmutableState(ImmutableState<T> original, StateID<T> type, T value) {
    this.type = type;
    this.value = value;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public StateID<T> type() {
    return type;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public T value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link State#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableState<T> withType(StateID<T> value) {
    if (this.type == value) return this;
    StateID<T> newValue = Objects.requireNonNull(value, "type");
    return new ImmutableState<>(this, newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link State#value() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableState<T> withValue(T value) {
    if (this.value == value) return this;
    T newValue = Objects.requireNonNull(value, "value");
    return new ImmutableState<>(this, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableState<?>
        && equalTo((ImmutableState<?>) another);
  }

  private boolean equalTo(ImmutableState<?> another) {
    return type.equals(another.type)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code State} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "State{"
        + "type=" + type
        + ", value=" + value
        + "}";
  }

  /**
   * Construct a new immutable {@code State} instance.
 * @param <T> generic parameter T
   * @param type The value for the {@code type} attribute
   * @param value The value for the {@code value} attribute
   * @return An immutable State instance
   */
  public static <T> ImmutableState<T> of(StateID<T> type, T value) {
    return new ImmutableState<>(type, value);
  }

  /**
   * Creates an immutable copy of a {@link State} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable State instance
   */
  public static <T> ImmutableState<T> copyOf(State<T> instance) {
    if (instance instanceof ImmutableState<?>) {
      return (ImmutableState<T>) instance;
    }
    return ImmutableState.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableState ImmutableState}.
   * <pre>
   * ImmutableState.&amp;lt;T&amp;gt;builder()
   *    .type(de.flapdoodle.transition.StateID&amp;lt;T&amp;gt;) // required {@link State#type() type}
   *    .value(T) // required {@link State#value() value}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableState builder
   */
  public static <T> ImmutableState.Builder<T> builder() {
    return new ImmutableState.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableState ImmutableState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "State", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private StateID<T> type;
    private T value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code State} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(State<T> instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.type());
      value(instance.value());
      return this;
    }

    /**
     * Initializes the value for the {@link State#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> type(StateID<T> type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link State#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> value(T value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableState ImmutableState}.
     * @return An immutable instance of State
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableState<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableState<>(null, type, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build State, some of required attributes are not set " + attributes;
    }
  }
}
