package de.flapdoodle.transition.processlike.edges;

import de.flapdoodle.transition.StateID;
import de.flapdoodle.types.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Conditional}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConditional.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableConditional.of()}.
 */
@Generated(from = "Conditional", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableConditional<S, D1, D2>
    implements Conditional<S, D1, D2> {
  private final StateID<S> source;
  private final StateID<D1> firstDestination;
  private final StateID<D2> secondDestination;
  private final Function<S, Either<D1, D2>> action;

  private ImmutableConditional(
      StateID<S> source,
      StateID<D1> firstDestination,
      StateID<D2> secondDestination,
      Function<S, Either<D1, D2>> action) {
    this.source = Objects.requireNonNull(source, "source");
    this.firstDestination = Objects.requireNonNull(firstDestination, "firstDestination");
    this.secondDestination = Objects.requireNonNull(secondDestination, "secondDestination");
    this.action = Objects.requireNonNull(action, "action");
  }

  private ImmutableConditional(
      ImmutableConditional<S, D1, D2> original,
      StateID<S> source,
      StateID<D1> firstDestination,
      StateID<D2> secondDestination,
      Function<S, Either<D1, D2>> action) {
    this.source = source;
    this.firstDestination = firstDestination;
    this.secondDestination = secondDestination;
    this.action = action;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @Override
  public StateID<S> source() {
    return source;
  }

  /**
   * @return The value of the {@code firstDestination} attribute
   */
  @Override
  public StateID<D1> firstDestination() {
    return firstDestination;
  }

  /**
   * @return The value of the {@code secondDestination} attribute
   */
  @Override
  public StateID<D2> secondDestination() {
    return secondDestination;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @Override
  public Function<S, Either<D1, D2>> action() {
    return action;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Conditional#source() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConditional<S, D1, D2> withSource(StateID<S> value) {
    if (this.source == value) return this;
    StateID<S> newValue = Objects.requireNonNull(value, "source");
    return new ImmutableConditional<>(this, newValue, this.firstDestination, this.secondDestination, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Conditional#firstDestination() firstDestination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for firstDestination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConditional<S, D1, D2> withFirstDestination(StateID<D1> value) {
    if (this.firstDestination == value) return this;
    StateID<D1> newValue = Objects.requireNonNull(value, "firstDestination");
    return new ImmutableConditional<>(this, this.source, newValue, this.secondDestination, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Conditional#secondDestination() secondDestination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for secondDestination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConditional<S, D1, D2> withSecondDestination(StateID<D2> value) {
    if (this.secondDestination == value) return this;
    StateID<D2> newValue = Objects.requireNonNull(value, "secondDestination");
    return new ImmutableConditional<>(this, this.source, this.firstDestination, newValue, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Conditional#action() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConditional<S, D1, D2> withAction(Function<S, Either<D1, D2>> value) {
    if (this.action == value) return this;
    Function<S, Either<D1, D2>> newValue = Objects.requireNonNull(value, "action");
    return new ImmutableConditional<>(this, this.source, this.firstDestination, this.secondDestination, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConditional} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConditional<?, ?, ?>
        && equalTo((ImmutableConditional<?, ?, ?>) another);
  }

  private boolean equalTo(ImmutableConditional<?, ?, ?> another) {
    return source.equals(another.source)
        && firstDestination.equals(another.firstDestination)
        && secondDestination.equals(another.secondDestination)
        && action.equals(another.action);
  }

  /**
   * Computes a hash code from attributes: {@code source}, {@code firstDestination}, {@code secondDestination}, {@code action}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + source.hashCode();
    h += (h << 5) + firstDestination.hashCode();
    h += (h << 5) + secondDestination.hashCode();
    h += (h << 5) + action.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Conditional} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Conditional{"
        + "source=" + source
        + ", firstDestination=" + firstDestination
        + ", secondDestination=" + secondDestination
        + ", action=" + action
        + "}";
  }

  /**
   * Construct a new immutable {@code Conditional} instance.
 * @param <S> generic parameter S
 * @param <D1> generic parameter D1
 * @param <D2> generic parameter D2
   * @param source The value for the {@code source} attribute
   * @param firstDestination The value for the {@code firstDestination} attribute
   * @param secondDestination The value for the {@code secondDestination} attribute
   * @param action The value for the {@code action} attribute
   * @return An immutable Conditional instance
   */
  public static <S, D1, D2> ImmutableConditional<S, D1, D2> of(StateID<S> source, StateID<D1> firstDestination, StateID<D2> secondDestination, Function<S, Either<D1, D2>> action) {
    return new ImmutableConditional<>(source, firstDestination, secondDestination, action);
  }

  /**
   * Creates an immutable copy of a {@link Conditional} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <S> generic parameter S
   * @param <D1> generic parameter D1
   * @param <D2> generic parameter D2
   * @param instance The instance to copy
   * @return A copied immutable Conditional instance
   */
  public static <S, D1, D2> ImmutableConditional<S, D1, D2> copyOf(Conditional<S, D1, D2> instance) {
    if (instance instanceof ImmutableConditional<?, ?, ?>) {
      return (ImmutableConditional<S, D1, D2>) instance;
    }
    return ImmutableConditional.<S, D1, D2>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConditional ImmutableConditional}.
   * <pre>
   * ImmutableConditional.&amp;lt;S, D1, D2&amp;gt;builder()
   *    .source(de.flapdoodle.transition.StateID&amp;lt;S&amp;gt;) // required {@link Conditional#source() source}
   *    .firstDestination(de.flapdoodle.transition.StateID&amp;lt;D1&amp;gt;) // required {@link Conditional#firstDestination() firstDestination}
   *    .secondDestination(de.flapdoodle.transition.StateID&amp;lt;D2&amp;gt;) // required {@link Conditional#secondDestination() secondDestination}
   *    .action(function.Function&amp;lt;S, de.flapdoodle.types.Either&amp;lt;D1, D2&amp;gt;&amp;gt;) // required {@link Conditional#action() action}
   *    .build();
   * </pre>
   * @param <S> generic parameter S
   * @param <D1> generic parameter D1
   * @param <D2> generic parameter D2
   * @return A new ImmutableConditional builder
   */
  public static <S, D1, D2> ImmutableConditional.Builder<S, D1, D2> builder() {
    return new ImmutableConditional.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableConditional ImmutableConditional}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Conditional", generator = "Immutables")
  public static final class Builder<S, D1, D2> {
    private static final long INIT_BIT_SOURCE = 0x1L;
    private static final long INIT_BIT_FIRST_DESTINATION = 0x2L;
    private static final long INIT_BIT_SECOND_DESTINATION = 0x4L;
    private static final long INIT_BIT_ACTION = 0x8L;
    private long initBits = 0xfL;

    private StateID<S> source;
    private StateID<D1> firstDestination;
    private StateID<D2> secondDestination;
    private Function<S, Either<D1, D2>> action;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Conditional} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D1, D2> from(Conditional<S, D1, D2> instance) {
      Objects.requireNonNull(instance, "instance");
      source(instance.source());
      firstDestination(instance.firstDestination());
      secondDestination(instance.secondDestination());
      action(instance.action());
      return this;
    }

    /**
     * Initializes the value for the {@link Conditional#source() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D1, D2> source(StateID<S> source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link Conditional#firstDestination() firstDestination} attribute.
     * @param firstDestination The value for firstDestination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D1, D2> firstDestination(StateID<D1> firstDestination) {
      this.firstDestination = Objects.requireNonNull(firstDestination, "firstDestination");
      initBits &= ~INIT_BIT_FIRST_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link Conditional#secondDestination() secondDestination} attribute.
     * @param secondDestination The value for secondDestination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D1, D2> secondDestination(StateID<D2> secondDestination) {
      this.secondDestination = Objects.requireNonNull(secondDestination, "secondDestination");
      initBits &= ~INIT_BIT_SECOND_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link Conditional#action() action} attribute.
     * @param action The value for action 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D1, D2> action(Function<S, Either<D1, D2>> action) {
      this.action = Objects.requireNonNull(action, "action");
      initBits &= ~INIT_BIT_ACTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConditional ImmutableConditional}.
     * @return An immutable instance of Conditional
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConditional<S, D1, D2> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableConditional<>(null, source, firstDestination, secondDestination, action);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_FIRST_DESTINATION) != 0) attributes.add("firstDestination");
      if ((initBits & INIT_BIT_SECOND_DESTINATION) != 0) attributes.add("secondDestination");
      if ((initBits & INIT_BIT_ACTION) != 0) attributes.add("action");
      return "Cannot build Conditional, some of required attributes are not set " + attributes;
    }
  }
}
