package de.flapdoodle.transition.processlike.edges;

import de.flapdoodle.transition.StateID;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Step}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStep.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableStep.of()}.
 */
@Generated(from = "Step", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableStep<S, D> implements Step<S, D> {
  private final StateID<S> source;
  private final StateID<D> destination;
  private final Function<S, D> action;

  private ImmutableStep(
      StateID<S> source,
      StateID<D> destination,
      Function<S, D> action) {
    this.source = Objects.requireNonNull(source, "source");
    this.destination = Objects.requireNonNull(destination, "destination");
    this.action = Objects.requireNonNull(action, "action");
  }

  private ImmutableStep(
      ImmutableStep<S, D> original,
      StateID<S> source,
      StateID<D> destination,
      Function<S, D> action) {
    this.source = source;
    this.destination = destination;
    this.action = action;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @Override
  public StateID<S> source() {
    return source;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public StateID<D> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @Override
  public Function<S, D> action() {
    return action;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Step#source() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStep<S, D> withSource(StateID<S> value) {
    if (this.source == value) return this;
    StateID<S> newValue = Objects.requireNonNull(value, "source");
    return new ImmutableStep<>(this, newValue, this.destination, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Step#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStep<S, D> withDestination(StateID<D> value) {
    if (this.destination == value) return this;
    StateID<D> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableStep<>(this, this.source, newValue, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Step#action() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStep<S, D> withAction(Function<S, D> value) {
    if (this.action == value) return this;
    Function<S, D> newValue = Objects.requireNonNull(value, "action");
    return new ImmutableStep<>(this, this.source, this.destination, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStep} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStep<?, ?>
        && equalTo((ImmutableStep<?, ?>) another);
  }

  private boolean equalTo(ImmutableStep<?, ?> another) {
    return source.equals(another.source)
        && destination.equals(another.destination)
        && action.equals(another.action);
  }

  /**
   * Computes a hash code from attributes: {@code source}, {@code destination}, {@code action}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + source.hashCode();
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + action.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Step} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Step{"
        + "source=" + source
        + ", destination=" + destination
        + ", action=" + action
        + "}";
  }

  /**
   * Construct a new immutable {@code Step} instance.
 * @param <S> generic parameter S
 * @param <D> generic parameter D
   * @param source The value for the {@code source} attribute
   * @param destination The value for the {@code destination} attribute
   * @param action The value for the {@code action} attribute
   * @return An immutable Step instance
   */
  public static <S, D> ImmutableStep<S, D> of(StateID<S> source, StateID<D> destination, Function<S, D> action) {
    return new ImmutableStep<>(source, destination, action);
  }

  /**
   * Creates an immutable copy of a {@link Step} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <S> generic parameter S
   * @param <D> generic parameter D
   * @param instance The instance to copy
   * @return A copied immutable Step instance
   */
  public static <S, D> ImmutableStep<S, D> copyOf(Step<S, D> instance) {
    if (instance instanceof ImmutableStep<?, ?>) {
      return (ImmutableStep<S, D>) instance;
    }
    return ImmutableStep.<S, D>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStep ImmutableStep}.
   * <pre>
   * ImmutableStep.&amp;lt;S, D&amp;gt;builder()
   *    .source(de.flapdoodle.transition.StateID&amp;lt;S&amp;gt;) // required {@link Step#source() source}
   *    .destination(de.flapdoodle.transition.StateID&amp;lt;D&amp;gt;) // required {@link Step#destination() destination}
   *    .action(function.Function&amp;lt;S, D&amp;gt;) // required {@link Step#action() action}
   *    .build();
   * </pre>
   * @param <S> generic parameter S
   * @param <D> generic parameter D
   * @return A new ImmutableStep builder
   */
  public static <S, D> ImmutableStep.Builder<S, D> builder() {
    return new ImmutableStep.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableStep ImmutableStep}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Step", generator = "Immutables")
  public static final class Builder<S, D> {
    private static final long INIT_BIT_SOURCE = 0x1L;
    private static final long INIT_BIT_DESTINATION = 0x2L;
    private static final long INIT_BIT_ACTION = 0x4L;
    private long initBits = 0x7L;

    private StateID<S> source;
    private StateID<D> destination;
    private Function<S, D> action;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Step} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D> from(Step<S, D> instance) {
      Objects.requireNonNull(instance, "instance");
      source(instance.source());
      destination(instance.destination());
      action(instance.action());
      return this;
    }

    /**
     * Initializes the value for the {@link Step#source() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D> source(StateID<S> source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link Step#destination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D> destination(StateID<D> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link Step#action() action} attribute.
     * @param action The value for action 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D> action(Function<S, D> action) {
      this.action = Objects.requireNonNull(action, "action");
      initBits &= ~INIT_BIT_ACTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStep ImmutableStep}.
     * @return An immutable instance of Step
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStep<S, D> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStep<>(null, source, destination, action);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      if ((initBits & INIT_BIT_ACTION) != 0) attributes.add("action");
      return "Cannot build Step, some of required attributes are not set " + attributes;
    }
  }
}
