package de.flapdoodle.transition.initlike.edges;

import de.flapdoodle.transition.StateID;
import de.flapdoodle.transition.initlike.State;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Depends}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDepends.builder()}.
 */
@Generated(from = "Depends", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDepends<S, D> implements Depends<S, D> {
  private final StateID<S> source;
  private final StateID<D> destination;
  private final Function<S, State<D>> action;

  private ImmutableDepends(
      StateID<S> source,
      StateID<D> destination,
      Function<S, State<D>> action) {
    this.source = source;
    this.destination = destination;
    this.action = action;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @Override
  public StateID<S> source() {
    return source;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public StateID<D> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @Override
  public Function<S, State<D>> action() {
    return action;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Depends#source() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDepends<S, D> withSource(StateID<S> value) {
    if (this.source == value) return this;
    StateID<S> newValue = Objects.requireNonNull(value, "source");
    return new ImmutableDepends<>(newValue, this.destination, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Depends#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDepends<S, D> withDestination(StateID<D> value) {
    if (this.destination == value) return this;
    StateID<D> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableDepends<>(this.source, newValue, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Depends#action() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDepends<S, D> withAction(Function<S, State<D>> value) {
    if (this.action == value) return this;
    Function<S, State<D>> newValue = Objects.requireNonNull(value, "action");
    return new ImmutableDepends<>(this.source, this.destination, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDepends} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDepends<?, ?>
        && equalTo((ImmutableDepends<?, ?>) another);
  }

  private boolean equalTo(ImmutableDepends<?, ?> another) {
    return source.equals(another.source)
        && destination.equals(another.destination)
        && action.equals(another.action);
  }

  /**
   * Computes a hash code from attributes: {@code source}, {@code destination}, {@code action}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + source.hashCode();
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + action.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Depends} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Depends{"
        + "source=" + source
        + ", destination=" + destination
        + ", action=" + action
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Depends} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <S> generic parameter S
   * @param <D> generic parameter D
   * @param instance The instance to copy
   * @return A copied immutable Depends instance
   */
  public static <S, D> ImmutableDepends<S, D> copyOf(Depends<S, D> instance) {
    if (instance instanceof ImmutableDepends<?, ?>) {
      return (ImmutableDepends<S, D>) instance;
    }
    return ImmutableDepends.<S, D>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDepends ImmutableDepends}.
   * <pre>
   * ImmutableDepends.&amp;lt;S, D&amp;gt;builder()
   *    .source(de.flapdoodle.transition.StateID&amp;lt;S&amp;gt;) // required {@link Depends#source() source}
   *    .destination(de.flapdoodle.transition.StateID&amp;lt;D&amp;gt;) // required {@link Depends#destination() destination}
   *    .action(function.Function&amp;lt;S, de.flapdoodle.transition.initlike.State&amp;lt;D&amp;gt;&amp;gt;) // required {@link Depends#action() action}
   *    .build();
   * </pre>
   * @param <S> generic parameter S
   * @param <D> generic parameter D
   * @return A new ImmutableDepends builder
   */
  public static <S, D> ImmutableDepends.Builder<S, D> builder() {
    return new ImmutableDepends.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableDepends ImmutableDepends}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Depends", generator = "Immutables")
  public static final class Builder<S, D> {
    private static final long INIT_BIT_SOURCE = 0x1L;
    private static final long INIT_BIT_DESTINATION = 0x2L;
    private static final long INIT_BIT_ACTION = 0x4L;
    private long initBits = 0x7L;

    private StateID<S> source;
    private StateID<D> destination;
    private Function<S, State<D>> action;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Depends} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D> from(Depends<S, D> instance) {
      Objects.requireNonNull(instance, "instance");
      source(instance.source());
      destination(instance.destination());
      action(instance.action());
      return this;
    }

    /**
     * Initializes the value for the {@link Depends#source() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D> source(StateID<S> source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link Depends#destination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D> destination(StateID<D> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link Depends#action() action} attribute.
     * @param action The value for action 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S, D> action(Function<S, State<D>> action) {
      this.action = Objects.requireNonNull(action, "action");
      initBits &= ~INIT_BIT_ACTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDepends ImmutableDepends}.
     * @return An immutable instance of Depends
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDepends<S, D> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDepends<>(source, destination, action);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      if ((initBits & INIT_BIT_ACTION) != 0) attributes.add("action");
      return "Cannot build Depends, some of required attributes are not set " + attributes;
    }
  }
}
