package de.flapdoodle.transition.initlike.edges;

import de.flapdoodle.transition.StateID;
import de.flapdoodle.transition.initlike.State;
import de.flapdoodle.transition.types.TriFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Merge3}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMerge3.builder()}.
 */
@Generated(from = "Merge3", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableMerge3<L, M, R, D>
    implements Merge3<L, M, R, D> {
  private final StateID<L> left;
  private final StateID<M> middle;
  private final StateID<R> right;
  private final StateID<D> destination;
  private final TriFunction<L, M, R, State<D>> action;

  private ImmutableMerge3(
      StateID<L> left,
      StateID<M> middle,
      StateID<R> right,
      StateID<D> destination,
      TriFunction<L, M, R, State<D>> action) {
    this.left = left;
    this.middle = middle;
    this.right = right;
    this.destination = destination;
    this.action = action;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public StateID<L> left() {
    return left;
  }

  /**
   * @return The value of the {@code middle} attribute
   */
  @Override
  public StateID<M> middle() {
    return middle;
  }

  /**
   * @return The value of the {@code right} attribute
   */
  @Override
  public StateID<R> right() {
    return right;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public StateID<D> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @Override
  public TriFunction<L, M, R, State<D>> action() {
    return action;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge3#left() left} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge3<L, M, R, D> withLeft(StateID<L> value) {
    if (this.left == value) return this;
    StateID<L> newValue = Objects.requireNonNull(value, "left");
    return new ImmutableMerge3<>(newValue, this.middle, this.right, this.destination, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge3#middle() middle} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for middle
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge3<L, M, R, D> withMiddle(StateID<M> value) {
    if (this.middle == value) return this;
    StateID<M> newValue = Objects.requireNonNull(value, "middle");
    return new ImmutableMerge3<>(this.left, newValue, this.right, this.destination, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge3#right() right} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for right
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge3<L, M, R, D> withRight(StateID<R> value) {
    if (this.right == value) return this;
    StateID<R> newValue = Objects.requireNonNull(value, "right");
    return new ImmutableMerge3<>(this.left, this.middle, newValue, this.destination, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge3#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge3<L, M, R, D> withDestination(StateID<D> value) {
    if (this.destination == value) return this;
    StateID<D> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableMerge3<>(this.left, this.middle, this.right, newValue, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Merge3#action() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMerge3<L, M, R, D> withAction(TriFunction<L, M, R, State<D>> value) {
    if (this.action == value) return this;
    TriFunction<L, M, R, State<D>> newValue = Objects.requireNonNull(value, "action");
    return new ImmutableMerge3<>(this.left, this.middle, this.right, this.destination, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMerge3} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMerge3<?, ?, ?, ?>
        && equalTo((ImmutableMerge3<?, ?, ?, ?>) another);
  }

  private boolean equalTo(ImmutableMerge3<?, ?, ?, ?> another) {
    return left.equals(another.left)
        && middle.equals(another.middle)
        && right.equals(another.right)
        && destination.equals(another.destination)
        && action.equals(another.action);
  }

  /**
   * Computes a hash code from attributes: {@code left}, {@code middle}, {@code right}, {@code destination}, {@code action}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + left.hashCode();
    h += (h << 5) + middle.hashCode();
    h += (h << 5) + right.hashCode();
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + action.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Merge3} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Merge3{"
        + "left=" + left
        + ", middle=" + middle
        + ", right=" + right
        + ", destination=" + destination
        + ", action=" + action
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Merge3} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <L> generic parameter L
   * @param <M> generic parameter M
   * @param <R> generic parameter R
   * @param <D> generic parameter D
   * @param instance The instance to copy
   * @return A copied immutable Merge3 instance
   */
  public static <L, M, R, D> ImmutableMerge3<L, M, R, D> copyOf(Merge3<L, M, R, D> instance) {
    if (instance instanceof ImmutableMerge3<?, ?, ?, ?>) {
      return (ImmutableMerge3<L, M, R, D>) instance;
    }
    return ImmutableMerge3.<L, M, R, D>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMerge3 ImmutableMerge3}.
   * <pre>
   * ImmutableMerge3.&amp;lt;L, M, R, D&amp;gt;builder()
   *    .left(de.flapdoodle.transition.StateID&amp;lt;L&amp;gt;) // required {@link Merge3#left() left}
   *    .middle(de.flapdoodle.transition.StateID&amp;lt;M&amp;gt;) // required {@link Merge3#middle() middle}
   *    .right(de.flapdoodle.transition.StateID&amp;lt;R&amp;gt;) // required {@link Merge3#right() right}
   *    .destination(de.flapdoodle.transition.StateID&amp;lt;D&amp;gt;) // required {@link Merge3#destination() destination}
   *    .action(de.flapdoodle.transition.types.TriFunction&amp;lt;L, M, R, de.flapdoodle.transition.initlike.State&amp;lt;D&amp;gt;&amp;gt;) // required {@link Merge3#action() action}
   *    .build();
   * </pre>
   * @param <L> generic parameter L
   * @param <M> generic parameter M
   * @param <R> generic parameter R
   * @param <D> generic parameter D
   * @return A new ImmutableMerge3 builder
   */
  public static <L, M, R, D> ImmutableMerge3.Builder<L, M, R, D> builder() {
    return new ImmutableMerge3.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableMerge3 ImmutableMerge3}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Merge3", generator = "Immutables")
  public static final class Builder<L, M, R, D> {
    private static final long INIT_BIT_LEFT = 0x1L;
    private static final long INIT_BIT_MIDDLE = 0x2L;
    private static final long INIT_BIT_RIGHT = 0x4L;
    private static final long INIT_BIT_DESTINATION = 0x8L;
    private static final long INIT_BIT_ACTION = 0x10L;
    private long initBits = 0x1fL;

    private StateID<L> left;
    private StateID<M> middle;
    private StateID<R> right;
    private StateID<D> destination;
    private TriFunction<L, M, R, State<D>> action;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Merge3} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, M, R, D> from(Merge3<L, M, R, D> instance) {
      Objects.requireNonNull(instance, "instance");
      left(instance.left());
      middle(instance.middle());
      right(instance.right());
      destination(instance.destination());
      action(instance.action());
      return this;
    }

    /**
     * Initializes the value for the {@link Merge3#left() left} attribute.
     * @param left The value for left 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, M, R, D> left(StateID<L> left) {
      this.left = Objects.requireNonNull(left, "left");
      initBits &= ~INIT_BIT_LEFT;
      return this;
    }

    /**
     * Initializes the value for the {@link Merge3#middle() middle} attribute.
     * @param middle The value for middle 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, M, R, D> middle(StateID<M> middle) {
      this.middle = Objects.requireNonNull(middle, "middle");
      initBits &= ~INIT_BIT_MIDDLE;
      return this;
    }

    /**
     * Initializes the value for the {@link Merge3#right() right} attribute.
     * @param right The value for right 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, M, R, D> right(StateID<R> right) {
      this.right = Objects.requireNonNull(right, "right");
      initBits &= ~INIT_BIT_RIGHT;
      return this;
    }

    /**
     * Initializes the value for the {@link Merge3#destination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, M, R, D> destination(StateID<D> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link Merge3#action() action} attribute.
     * @param action The value for action 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, M, R, D> action(TriFunction<L, M, R, State<D>> action) {
      this.action = Objects.requireNonNull(action, "action");
      initBits &= ~INIT_BIT_ACTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMerge3 ImmutableMerge3}.
     * @return An immutable instance of Merge3
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMerge3<L, M, R, D> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMerge3<>(left, middle, right, destination, action);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LEFT) != 0) attributes.add("left");
      if ((initBits & INIT_BIT_MIDDLE) != 0) attributes.add("middle");
      if ((initBits & INIT_BIT_RIGHT) != 0) attributes.add("right");
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      if ((initBits & INIT_BIT_ACTION) != 0) attributes.add("action");
      return "Cannot build Merge3, some of required attributes are not set " + attributes;
    }
  }
}
