package de.flapdoodle.transition.processlike.edges;

import de.flapdoodle.transition.StateID;
import de.flapdoodle.transition.processlike.HasSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link End}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEnd.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableEnd.of()}.
 */
@Generated(from = "End", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableEnd<S> implements End<S> {
  private final StateID<S> source;
  private final Consumer<S> action;

  private ImmutableEnd(StateID<S> source, Consumer<S> action) {
    this.source = Objects.requireNonNull(source, "source");
    this.action = Objects.requireNonNull(action, "action");
  }

  private ImmutableEnd(
      ImmutableEnd<S> original,
      StateID<S> source,
      Consumer<S> action) {
    this.source = source;
    this.action = action;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @Override
  public StateID<S> source() {
    return source;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @Override
  public Consumer<S> action() {
    return action;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link End#source() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnd<S> withSource(StateID<S> value) {
    if (this.source == value) return this;
    StateID<S> newValue = Objects.requireNonNull(value, "source");
    return new ImmutableEnd<>(this, newValue, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link End#action() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnd<S> withAction(Consumer<S> value) {
    if (this.action == value) return this;
    Consumer<S> newValue = Objects.requireNonNull(value, "action");
    return new ImmutableEnd<>(this, this.source, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEnd} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEnd<?>
        && equalTo((ImmutableEnd<?>) another);
  }

  private boolean equalTo(ImmutableEnd<?> another) {
    return source.equals(another.source)
        && action.equals(another.action);
  }

  /**
   * Computes a hash code from attributes: {@code source}, {@code action}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + source.hashCode();
    h += (h << 5) + action.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code End} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "End{"
        + "source=" + source
        + ", action=" + action
        + "}";
  }

  /**
   * Construct a new immutable {@code End} instance.
 * @param <S> generic parameter S
   * @param source The value for the {@code source} attribute
   * @param action The value for the {@code action} attribute
   * @return An immutable End instance
   */
  public static <S> ImmutableEnd<S> of(StateID<S> source, Consumer<S> action) {
    return new ImmutableEnd<>(source, action);
  }

  /**
   * Creates an immutable copy of a {@link End} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <S> generic parameter S
   * @param instance The instance to copy
   * @return A copied immutable End instance
   */
  public static <S> ImmutableEnd<S> copyOf(End<S> instance) {
    if (instance instanceof ImmutableEnd<?>) {
      return (ImmutableEnd<S>) instance;
    }
    return ImmutableEnd.<S>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEnd ImmutableEnd}.
   * <pre>
   * ImmutableEnd.&amp;lt;S&amp;gt;builder()
   *    .source(de.flapdoodle.transition.StateID&amp;lt;S&amp;gt;) // required {@link End#source() source}
   *    .action(function.Consumer&amp;lt;S&amp;gt;) // required {@link End#action() action}
   *    .build();
   * </pre>
   * @param <S> generic parameter S
   * @return A new ImmutableEnd builder
   */
  public static <S> ImmutableEnd.Builder<S> builder() {
    return new ImmutableEnd.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableEnd ImmutableEnd}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "End", generator = "Immutables")
  public static final class Builder<S> {
    private static final long INIT_BIT_SOURCE = 0x1L;
    private static final long INIT_BIT_ACTION = 0x2L;
    private long initBits = 0x3L;

    private StateID<S> source;
    private Consumer<S> action;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.transition.processlike.HasSource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S> from(HasSource<S> instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.transition.processlike.edges.End} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S> from(End<S> instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    @SuppressWarnings("unchecked")
    private void from(Object object) {
      long bits = 0;
      if (object instanceof HasSource<?>) {
        HasSource<S> instance = (HasSource<S>) object;
        if ((bits & 0x1L) == 0) {
          source(instance.source());
          bits |= 0x1L;
        }
      }
      if (object instanceof End<?>) {
        End<S> instance = (End<S>) object;
        action(instance.action());
        if ((bits & 0x1L) == 0) {
          source(instance.source());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link End#source() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S> source(StateID<S> source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link End#action() action} attribute.
     * @param action The value for action 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<S> action(Consumer<S> action) {
      this.action = Objects.requireNonNull(action, "action");
      initBits &= ~INIT_BIT_ACTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEnd ImmutableEnd}.
     * @return An immutable instance of End
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEnd<S> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEnd<>(null, source, action);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_ACTION) != 0) attributes.add("action");
      return "Cannot build End, some of required attributes are not set " + attributes;
    }
  }
}
