/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.functions;

import de.flapdoodle.functions.Function1;
import de.flapdoodle.functions.Function2;
import de.flapdoodle.functions.Function3;

public class Functions {
    private Functions() {
    }

    public static <R, X, T> Function1<R, T> join(Function1<R, ? super X> outer, Function1<X, ? super T> inner) {
        return new JoinedFunction1<R, X, T>(outer, inner);
    }

    public static <R, T1, T2, X> Function2<R, T1, T2> join(Function2<R, ? super T1, ? super X> outer, Function1<X, ? super T2> inner) {
        return new JoinedFunction2<R, T1, T2, X>(outer, inner);
    }

    public static <R, T1, T2, T3, X> Function3<R, T1, T2, T3> join(Function2<R, ? super T1, ? super X> outer, Function2<X, ? super T2, ? super T3> inner) {
        return new JoinedFunction3<R, T1, T2, T3, X>(outer, inner);
    }

    public static <R, T1, T2, T3, A, B> Function3<R, T1, T2, T3> join(Function2<R, ? super A, ? super B> outer, Function2<A, ? super T1, ? super T2> left, Function2<B, ? super T2, ? super T3> right) {
        return new JoinedFunction33<R, T1, T2, T3, A, B>(outer, left, right);
    }

    public static <R, T1, T2> Function2<R, T1, T2> swap(Function2<R, ? super T2, ? super T1> source) {
        return new SwappedTypeFunction<R, T1, T2>(source);
    }

    public static <R, T> Function1<R, T> orNull(final Function1<R, T> transformation) {
        return new Function1<R, T>(){

            @Override
            public R apply(T value) {
                return value != null ? (Object)transformation.apply(value) : null;
            }
        };
    }

    static class SwappedTypeFunction<R, T1, T2>
    implements Function2<R, T1, T2> {
        private final Function2<R, ? super T2, ? super T1> _source;

        public SwappedTypeFunction(Function2<R, ? super T2, ? super T1> source) {
            this._source = source;
        }

        @Override
        public R apply(T1 a, T2 b) {
            return this._source.apply(b, a);
        }
    }

    static class JoinedFunction33<R, T1, T2, T3, A, B>
    implements Function3<R, T1, T2, T3> {
        private final Function2<R, ? super A, ? super B> _outer;
        private final Function2<A, ? super T1, ? super T2> _left;
        private final Function2<B, ? super T2, ? super T3> _right;

        public JoinedFunction33(Function2<R, ? super A, ? super B> outer, Function2<A, ? super T1, ? super T2> left, Function2<B, ? super T2, ? super T3> right) {
            this._outer = outer;
            this._left = left;
            this._right = right;
        }

        @Override
        public R apply(T1 a, T2 b, T3 c) {
            return this._outer.apply(this._left.apply(a, b), this._right.apply(b, c));
        }
    }

    static class JoinedFunction3<R, T1, T2, T3, X>
    implements Function3<R, T1, T2, T3> {
        private final Function2<R, ? super T1, ? super X> _outer;
        private final Function2<X, ? super T2, ? super T3> _inner;

        public JoinedFunction3(Function2<R, ? super T1, ? super X> outer, Function2<X, ? super T2, ? super T3> inner) {
            this._outer = outer;
            this._inner = inner;
        }

        @Override
        public R apply(T1 a, T2 b, T3 c) {
            return this._outer.apply(a, this._inner.apply(b, c));
        }
    }

    static class JoinedFunction2<R, T1, T2, X>
    implements Function2<R, T1, T2> {
        private final Function2<R, ? super T1, ? super X> _outer;
        private final Function1<X, ? super T2> _inner;

        public JoinedFunction2(Function2<R, ? super T1, ? super X> outer, Function1<X, ? super T2> inner) {
            this._outer = outer;
            this._inner = inner;
        }

        @Override
        public R apply(T1 a, T2 b) {
            return this._outer.apply(a, this._inner.apply(b));
        }
    }

    static class JoinedFunction1<R, X, T>
    implements Function1<R, T> {
        private final Function1<R, ? super X> _outer;
        private final Function1<X, ? super T> _inner;

        public JoinedFunction1(Function1<R, ? super X> a, Function1<X, ? super T> b) {
            this._outer = a;
            this._inner = b;
        }

        @Override
        public R apply(T value) {
            return this._outer.apply(this._inner.apply(value));
        }
    }
}

