/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.wicket.model.transformation;

import de.flapdoodle.functions.Function1;
import de.flapdoodle.wicket.model.IReadOnlyListModel;
import de.flapdoodle.wicket.model.transformation.AbstractReadOnlyDetachDelegationModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.model.IModel;

public class ListMappingModel<T, D>
extends AbstractReadOnlyDetachDelegationModel<List<D>>
implements IReadOnlyListModel<D> {
    private final IModel<? extends Iterable<? extends T>> source;
    private final Function1<D, T> map;

    public ListMappingModel(IModel<? extends Iterable<? extends T>> source, Function1<D, T> map) {
        super(source);
        this.source = source;
        this.map = map;
    }

    protected List<D> load() {
        return ListMappingModel.map((Iterable)this.source.getObject(), this.map);
    }

    protected static <T, I extends Iterable<? extends T>, D> List<D> map(I entries, Function1<D, T> map) {
        ArrayList<D> ret = new ArrayList<D>();
        for (T value : entries) {
            ret.add(map.apply(value));
        }
        return ret;
    }
}

