/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.wicket.model.transformation;

import de.flapdoodle.functions.Function1;
import de.flapdoodle.functions.Function2;
import de.flapdoodle.functions.Function3;
import de.flapdoodle.wicket.model.IMapableModel;
import de.flapdoodle.wicket.model.IMapableObjectAwareModel;
import de.flapdoodle.wicket.model.IReadOnlyModel;
import de.flapdoodle.wicket.model.transformation.Lazy;
import de.flapdoodle.wicket.model.transformation.ObjectAwarePropertyAccessModel;
import de.flapdoodle.wicket.model.transformation.PropertyAccessModel;
import de.flapdoodle.wicket.model.transformation.Transformator;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.lambda.SerializableBiConsumer;

public abstract class ModelSet {

    public static final class Set3<T1, T2, T3> {
        IModel<T1> _m1;
        IModel<T2> _m2;
        IModel<T3> _m3;

        public Set3(IModel<T1> m1, IModel<T2> m2, IModel<T3> m3) {
            this._m1 = m1;
            this._m2 = m2;
            this._m3 = m3;
        }

        public <T> IReadOnlyModel<T> apply(Function3<T, ? super T1, ? super T2, ? super T3> function) {
            return new Transformator.Model3<T, T1, T2, T3>(this._m1, this._m2, this._m3, function);
        }

        public <T> IReadOnlyModel<T> applyLazy(Function3<T, ? super Lazy<? extends T1>, ? super Lazy<? extends T2>, ? super Lazy<? extends T3>> function) {
            return new Transformator.LazyModel3<T, T1, T2, T3>(this._m1, this._m2, this._m3, function);
        }
    }

    public static final class Set2<T1, T2> {
        IModel<T1> _m1;
        IModel<T2> _m2;

        public Set2(IModel<T1> m1, IModel<T2> m2) {
            this._m1 = m1;
            this._m2 = m2;
        }

        public <T> IReadOnlyModel<T> apply(Function2<T, ? super T1, ? super T2> function) {
            return new Transformator.Model2<T, T1, T2>(this._m1, this._m2, function);
        }

        public <T> IReadOnlyModel<T> applyLazy(Function2<T, ? super Lazy<? extends T1>, ? super Lazy<? extends T2>> function) {
            return new Transformator.LazyModel2<T, T1, T2>(this._m1, this._m2, function);
        }
    }

    public static final class Set1<T1> {
        IModel<T1> _m1;

        public Set1(IModel<T1> m1) {
            this._m1 = m1;
        }

        public <R> IReadOnlyModel<R> apply(Function1<R, ? super T1> function) {
            return new Transformator.Model1<R, T1>(this._m1, function);
        }

        public <R> IReadOnlyModel<R> applyLazy(Function1<R, ? super Lazy<? extends T1>> function) {
            return new Transformator.LazyModel1<R, T1>(this._m1, function);
        }

        public <R> IMapableObjectAwareModel<R> mapProperty(Class<R> type, Function1<R, ? super T1> read, SerializableBiConsumer<? super T1, R> write) {
            return new ObjectAwarePropertyAccessModel<T1, R>(this._m1, type, read, write);
        }

        public <R> IMapableModel<R> mapProperty(Function1<R, ? super T1> read, SerializableBiConsumer<? super T1, R> write) {
            return new PropertyAccessModel<T1, R>(this._m1, read, write);
        }
    }
}

