/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.wicket.model.transformation;

import de.flapdoodle.functions.Function1;
import de.flapdoodle.wicket.model.IMapableObjectAwareModel;
import org.apache.wicket.model.IModel;

public class ObjectAwareTransformator<T, R>
implements IMapableObjectAwareModel<R> {
    private final IModel<T> model;
    private final Class<R> type;
    private final Function1<R, ? super T> read;
    private final Function1<T, ? super R> write;

    public ObjectAwareTransformator(IModel<T> model, Class<R> type, Function1<R, ? super T> read, Function1<T, ? super R> write) {
        this.model = model;
        this.type = type;
        this.read = read;
        this.write = write;
    }

    public Class<R> getObjectClass() {
        return this.type;
    }

    public R getObject() {
        return this.read.apply(this.model.getObject());
    }

    public void setObject(R value) {
        this.model.setObject(this.write.apply(value));
    }

    public void detach() {
        this.model.detach();
    }
}

