/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.wicket.model;

import de.flapdoodle.functions.Function1;
import de.flapdoodle.functions.Functions;
import de.flapdoodle.functions.SymetricalFunction;
import de.flapdoodle.wicket.model.IMapableObjectAwareModel;
import de.flapdoodle.wicket.model.transformation.ObjectAwareTransformator;
import de.flapdoodle.wicket.model.transformation.TransformatorModel;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;

public interface IMapableModel<T>
extends IModel<T> {
    default public <R> IMapableObjectAwareModel<R> map(Class<R> type, SymetricalFunction<T, R> mapping) {
        return this.map(type, mapping, mapping.reverse());
    }

    default public <R> IMapableObjectAwareModel<R> map(Class<R> type, Function1<R, ? super T> read, Function1<T, ? super R> write) {
        return new ObjectAwareTransformator<T, R>(this, type, read, write);
    }

    default public <R> IMapableObjectAwareModel<R> mapNullable(Class<R> type, SymetricalFunction<T, R> mapping) {
        return this.mapNullable(type, mapping, mapping.reverse());
    }

    default public <R> IMapableObjectAwareModel<R> mapNullable(Class<R> type, Function1<R, ? super T> read, Function1<T, ? super R> write) {
        return new ObjectAwareTransformator<T, R>(this, type, Functions.orNull(read), Functions.orNull(write));
    }

    default public <R> IMapableModel<R> map(SymetricalFunction<T, R> mapping) {
        return this.map(mapping, mapping.reverse());
    }

    default public <R> IMapableModel<R> map(Function1<R, ? super T> read, Function1<T, ? super R> write) {
        return new TransformatorModel<T, R>(this, read, write);
    }

    default public <R> IMapableModel<R> mapNullable(SymetricalFunction<T, R> mapping) {
        return this.mapNullable(mapping, mapping.reverse());
    }

    default public <R> IMapableModel<R> mapNullable(Function1<R, ? super T> read, Function1<T, ? super R> write) {
        return new TransformatorModel<T, R>(this, Functions.orNull(read), Functions.orNull(write));
    }

    default public IMapableModel<T> andDetach(final IDetachable detachable) {
        final IMapableModel delegate = this;
        return new IMapableModel<T>(){

            public T getObject() {
                return delegate.getObject();
            }

            public void setObject(T object) {
                delegate.setObject(object);
            }

            public void detach() {
                delegate.detach();
                detachable.detach();
            }
        };
    }
}

