/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.wicket.model;

import de.flapdoodle.functions.Function1;
import de.flapdoodle.functions.Function2;
import de.flapdoodle.functions.Function3;
import de.flapdoodle.wicket.model.AbstractReadOnlyDetachedModel;
import de.flapdoodle.wicket.model.IReadOnlyIterableModel;
import de.flapdoodle.wicket.model.transformation.Functions;
import de.flapdoodle.wicket.model.transformation.Lazy;
import de.flapdoodle.wicket.model.transformation.ModelSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.model.IModel;

public abstract class Models {
    private Models() {
    }

    public static <T> ModelSet.Set1<T> on(IModel<T> source) {
        return new ModelSet.Set1<T>(source);
    }

    public static <T, I extends Iterable<T>> IReadOnlyIterableModel<T, I> asIterable(IModel<I> source) {
        return IReadOnlyIterableModel.asIterable(source);
    }

    public static <T1, T2> ModelSet.Set2<T1, T2> on(IModel<T1> first, IModel<T2> second) {
        return new ModelSet.Set2<T1, T2>(first, second);
    }

    public static <T1, T2, T3> ModelSet.Set3<T1, T2, T3> on(IModel<T1> first, IModel<T2> second, IModel<T3> third) {
        return new ModelSet.Set3<T1, T2, T3>(first, second, third);
    }

    public static <R, T> Functions.Reference1<R, T> apply(Function1<R, T> function) {
        return new Functions.Reference1<R, T>(function);
    }

    public static <R, T1, T2> Functions.Reference2<R, T1, T2> apply(Function2<R, T1, T2> function) {
        return new Functions.Reference2<R, T1, T2>(function);
    }

    public static <R, T1, T2, T3> Functions.Reference3<R, T1, T2, T3> apply(Function3<R, T1, T2, T3> function) {
        return new Functions.Reference3<R, T1, T2, T3>(function);
    }

    public static <R, T> Functions.LazyReference1<R, T> applyLazy(Function1<R, ? super Lazy<? extends T>> function) {
        return new Functions.LazyReference1(function);
    }

    public static <R, T1, T2> Functions.LazyReference2<R, T1, T2> applyLazy(Function2<R, ? super Lazy<? extends T1>, ? super Lazy<? extends T2>> function) {
        return new Functions.LazyReference2(function);
    }

    public static <R, T1, T2, T3> Functions.LazyReference3<R, T1, T2, T3> applyLazy(Function3<R, ? super Lazy<? extends T1>, ? super Lazy<? extends T2>, ? super Lazy<? extends T3>> function) {
        return new Functions.LazyReference3(function);
    }

    public static <T> IModel<List<T>> unmodifiable(IModel<? extends List<? extends T>> source) {
        return Models.on(source).apply(new UnmodifiableIfNotNull());
    }

    public static <T> IModel<List<T>> unmodifiable(final List<? extends T> list) {
        return new AbstractReadOnlyDetachedModel<List<T>>(){

            protected List<T> load() {
                return Collections.unmodifiableList(list);
            }
        };
    }

    public static <T> IModel<List<T>> emptyIfNull(IModel<? extends List<T>> source) {
        return Models.on(source).apply(new EmptyListIfNull());
    }

    public static <T> IModel<T> readOnly(IModel<? extends T> source) {
        return Models.on(source).apply(new Noop());
    }

    private static final class Noop<T>
    implements Function1<T, T> {
        private Noop() {
        }

        @Override
        public T apply(T value) {
            return value;
        }
    }

    private static final class EmptyListIfNull<T>
    implements Function1<List<T>, List<T>> {
        private EmptyListIfNull() {
        }

        @Override
        public List<T> apply(List<T> value) {
            return value != null ? value : new ArrayList();
        }
    }

    private static final class UnmodifiableIfNotNull<T>
    implements Function1<List<T>, List<? extends T>> {
        private UnmodifiableIfNotNull() {
        }

        @Override
        public List<T> apply(List<? extends T> value) {
            return value != null ? Collections.unmodifiableList(value) : null;
        }
    }
}

