/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.wicket.model.transformation;

import de.flapdoodle.functions.Function1;
import de.flapdoodle.wicket.model.IReadOnlyMapModel;
import de.flapdoodle.wicket.model.transformation.AbstractReadOnlyDetachDelegationModel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.wicket.model.IModel;

public class MapModel<K, V>
extends AbstractReadOnlyDetachDelegationModel<Map<K, V>>
implements IReadOnlyMapModel<K, V> {
    private final IModel<? extends Iterable<? extends V>> source;
    private final Function1<K, ? super V> keyTransformation;

    public MapModel(IModel<? extends Iterable<? extends V>> source, Function1<K, ? super V> keyTransformation) {
        super(source);
        this.source = source;
        this.keyTransformation = keyTransformation;
    }

    protected Map<K, V> load() {
        return MapModel.asMap((Iterable)this.source.getObject(), this.keyTransformation);
    }

    protected static <K, V> Map<K, V> asMap(Iterable<? extends V> src, Function1<K, ? super V> transformation) {
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        for (V value : src) {
            K key = transformation.apply(value);
            V old = result.put(key, value);
            if (old == null) continue;
            throw new IllegalArgumentException("multiple values got the same key: " + value + "," + old + " -> " + key);
        }
        return Collections.unmodifiableMap(result);
    }
}

