/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model.lambda;

import java.io.Serializable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.lambda.SerializableConsumer;
import org.apache.wicket.model.lambda.SerializableFunction;
import org.apache.wicket.model.lambda.SerializableSupplier;
import org.apache.wicket.util.lang.Objects;

public class Lambdas {
    public static <T, X, F extends SerializableFunction<X, T>> IModel<T> of(final IModel<X> base, final F getter) {
        return new IDefaultModel<T>(){
            private static final long serialVersionUID = 1L;

            @Override
            public T getObject() {
                Object object = base.getObject();
                if (object != null) {
                    return getter.apply(object);
                }
                return null;
            }

            @Override
            public void detach() {
                base.detach();
            }
        };
    }

    public static <T, X, Y, XY extends SerializableFunction<X, Y>, YT extends SerializableFunction<Y, T>> IModel<T> of(final IModel<X> base, final XY xToY, final YT yToT) {
        return new IDefaultModel<T>(){
            private static final long serialVersionUID = 1L;

            @Override
            public T getObject() {
                Object y;
                Object object = base.getObject();
                if (object != null && (y = xToY.apply(object)) != null) {
                    return yToT.apply(y);
                }
                return null;
            }

            @Override
            public void detach() {
                base.detach();
            }
        };
    }

    public static <T, G extends SerializableSupplier<T>, S extends SerializableConsumer<T>> IModel<T> of(G getter, S setter) {
        return new LambdaModel(getter, setter);
    }

    public static <T, S extends SerializableSupplier<T>> IModel<T> cachedReadOnly(final S getter) {
        return new LoadableDetachableModel<T>(){
            private static final long serialVersionUID = 1L;

            protected T load() {
                return getter.get();
            }
        };
    }

    public static <T, S extends SerializableSupplier<T>> IModel<T> readOnly(S getter) {
        return new ReadOnlyModel(getter);
    }

    public static <T, S extends Serializable & Consumer<T>> IModel<T> writeOnly(S setter) {
        return new WriteOnlyModel(setter);
    }

    static class LambdaModel<T, S extends Serializable & Supplier<T>, C extends Serializable & Consumer<T>>
    implements IModel<T> {
        private static final long serialVersionUID = 1L;
        private S supplier;
        private C consumer;

        public LambdaModel(S supplier, C consumer) {
            this.supplier = supplier;
            this.consumer = consumer;
        }

        public void detach() {
        }

        public T getObject() {
            return ((Supplier)this.supplier).get();
        }

        public void setObject(T object) {
            ((Consumer)this.consumer).accept(object);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.supplier, this.consumer});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LambdaModel other = (LambdaModel)obj;
            if (!java.util.Objects.equals(this.supplier, other.supplier)) {
                return false;
            }
            return java.util.Objects.equals(this.consumer, other.consumer);
        }
    }

    static class WriteOnlyModel<T, S extends Serializable & Consumer<T>>
    implements IDefaultModel<T> {
        private static final long serialVersionUID = 1L;
        private S setter;

        public WriteOnlyModel(S consumer) {
            this.setter = consumer;
        }

        @Override
        public void setObject(T object) {
            ((Consumer)this.setter).accept(object);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.setter});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WriteOnlyModel other = (WriteOnlyModel)obj;
            return java.util.Objects.equals(this.setter, other.setter);
        }
    }

    static class ReadOnlyModel<T, G extends SerializableSupplier<T>>
    implements IDefaultModel<T> {
        private static final long serialVersionUID = 1L;
        private G getter;

        public ReadOnlyModel(G getter) {
            this.getter = getter;
        }

        @Override
        public T getObject() {
            return this.getter.get();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getter});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReadOnlyModel other = (ReadOnlyModel)obj;
            return java.util.Objects.equals(this.getter, other.getter);
        }
    }

    static interface IDefaultModel<T>
    extends IModel<T> {
        default public T getObject() {
            throw new UnsupportedOperationException();
        }

        default public void setObject(T object) {
            throw new UnsupportedOperationException();
        }

        default public void detach() {
        }
    }
}

