/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model.lambda;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.apache.wicket.Application;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.core.util.objects.checker.CheckingObjectOutputStream;
import org.apache.wicket.core.util.objects.checker.IObjectChecker;
import org.apache.wicket.core.util.objects.checker.ObjectSerializationChecker;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.settings.ApplicationSettings;
import org.apache.wicket.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformSerializer
implements ISerializer {
    private static final Logger log = LoggerFactory.getLogger(PlatformSerializer.class);
    private final String applicationKey;

    public PlatformSerializer(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(Object object) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            try {
                oos = this.newObjectOutputStream(out);
                oos.writeObject(this.applicationKey);
                oos.writeObject(object);
            }
            finally {
                try {
                    IOUtils.close((Closeable)oos);
                }
                finally {
                    out.close();
                }
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Error serializing object " + object.getClass() + " [object=" + object + "]", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserialize(byte[] data) {
        ThreadContext old = ThreadContext.get((boolean)false);
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ObjectInputStream ois = null;
        try {
            Object object;
            Application oldApplication = ThreadContext.getApplication();
            try {
                Application app;
                ois = this.newObjectInputStream(in);
                String applicationName = (String)ois.readObject();
                if (applicationName != null && (app = Application.get((String)applicationName)) != null) {
                    ThreadContext.setApplication((Application)app);
                }
                object = ois.readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ThreadContext.setApplication((Application)oldApplication);
                        IOUtils.close((Closeable)ois);
                    }
                    finally {
                        in.close();
                    }
                    throw throwable;
                }
                catch (ClassNotFoundException cnfx) {
                    throw new RuntimeException("Could not deserialize object from byte[]", cnfx);
                }
                catch (IOException iox) {
                    throw new RuntimeException("Could not deserialize object from byte[]", iox);
                }
            }
            try {
                ThreadContext.setApplication((Application)oldApplication);
                IOUtils.close((Closeable)ois);
            }
            finally {
                in.close();
            }
            return object;
        }
        finally {
            ThreadContext.restore((ThreadContext)old);
        }
    }

    protected ObjectInputStream newObjectInputStream(InputStream in) throws IOException {
        return new ObjectInputStream(in);
    }

    protected ObjectOutputStream newObjectOutputStream(OutputStream out) throws IOException {
        return new ObjectOutputStream(out);
    }

    private static class SerializationCheckerObjectOutputStream
    extends ObjectOutputStream {
        private final OutputStream outputStream;
        private final ObjectOutputStream oos;

        private SerializationCheckerObjectOutputStream(OutputStream outputStream) throws IOException {
            this.outputStream = outputStream;
            this.oos = new ObjectOutputStream(outputStream);
        }

        @Override
        protected final void writeObjectOverride(Object obj) throws IOException {
            try {
                this.oos.writeObject(obj);
            }
            catch (NotSerializableException nsx) {
                if (CheckingObjectOutputStream.isAvailable()) {
                    try {
                        CheckingObjectOutputStream checkingObjectOutputStream = new CheckingObjectOutputStream(this.outputStream, new IObjectChecker[]{new ObjectSerializationChecker(nsx)});
                        checkingObjectOutputStream.writeObject(obj);
                    }
                    catch (Exception x) {
                        if (x instanceof CheckingObjectOutputStream.ObjectCheckException) {
                            throw (CheckingObjectOutputStream.ObjectCheckException)x;
                        }
                        x.initCause(nsx);
                        throw new WicketRuntimeException("A problem occurred while trying to collect debug information about not serializable object", (Throwable)x);
                    }
                    throw nsx;
                }
                throw nsx;
            }
            catch (Exception e) {
                log.error("error writing object " + obj + ": " + e.getMessage(), (Throwable)e);
                throw new WicketRuntimeException((Throwable)e);
            }
        }

        @Override
        public void flush() throws IOException {
            this.oos.flush();
        }

        @Override
        public void close() throws IOException {
            this.oos.close();
        }
    }

    private static class ClassResolverObjectInputStream
    extends ObjectInputStream {
        public ClassResolverObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String className = desc.getName();
            try {
                return super.resolveClass(desc);
            }
            catch (ClassNotFoundException ex1) {
                Class<?> candidate;
                block5: {
                    log.debug("Class not found by the object outputstream itself, trying the IClassResolver");
                    candidate = null;
                    try {
                        Application application = Application.get();
                        ApplicationSettings applicationSettings = application.getApplicationSettings();
                        IClassResolver classResolver = applicationSettings.getClassResolver();
                        candidate = classResolver.resolveClass(className);
                        if (candidate == null) {
                            candidate = super.resolveClass(desc);
                        }
                    }
                    catch (WicketRuntimeException ex) {
                        if (!(ex.getCause() instanceof ClassNotFoundException)) break block5;
                        throw (ClassNotFoundException)ex.getCause();
                    }
                }
                return candidate;
            }
        }
    }
}

