/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.classic4j;

import de.florianmichael.classic4j.ClassiCubeHandler;
import de.florianmichael.classic4j.api.JoinServerInterface;
import de.florianmichael.classic4j.model.betacraft.BCServerList;
import de.florianmichael.classic4j.request.betacraft.BCServerListRequest;
import de.florianmichael.classic4j.util.HttpClientUtils;
import de.florianmichael.classic4j.util.IPUtils;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Formatter;
import java.util.Scanner;
import java.util.function.Consumer;

public class BetaCraftHandler {
    public static final URI BETACRAFT_ROOT_URI = URI.create("https://api.betacraft.uk");
    @Deprecated
    public static final URI GET_MP_PASS = BETACRAFT_ROOT_URI.resolve("/getmppass.jsp");

    @Deprecated
    public static String requestMPPass(String username, String ip, int port, JoinServerInterface joinServerInterface) {
        return BetaCraftHandler.requestMPPass(username, ip, port, joinServerInterface, Throwable::printStackTrace);
    }

    @Deprecated
    public static String requestMPPass(String username, String ip, int port, JoinServerInterface joinServerInterface, Consumer<Throwable> throwableConsumer) {
        try {
            String server = InetAddress.getByName(ip).getHostAddress() + ":" + port;
            joinServerInterface.sendAuthRequest(BetaCraftHandler.sha1(server.getBytes()));
            InputStream connection = new URL(GET_MP_PASS + "?user=" + username + "&server=" + server).openStream();
            Scanner scanner = new Scanner(connection);
            StringBuilder response = new StringBuilder();
            while (scanner.hasNext()) {
                response.append(scanner.next());
            }
            connection.close();
            if (response.toString().contains("FAILED") || response.toString().contains("SERVER NOT FOUND")) {
                return "0";
            }
            return response.toString();
        }
        catch (Throwable t) {
            throwableConsumer.accept(t);
            return "0";
        }
    }

    public static void authenticate(JoinServerInterface joinServerInterface) {
        BetaCraftHandler.authenticate(joinServerInterface, Throwable::printStackTrace);
    }

    public static void authenticate(JoinServerInterface joinServerInterface, Consumer<Throwable> throwableConsumer) {
        try {
            joinServerInterface.sendAuthRequest(BetaCraftHandler.sha1(IPUtils.get().getBytes()));
        }
        catch (Throwable t) {
            throwableConsumer.accept(t);
        }
    }

    public static void requestV2ServerList(Consumer<BCServerList> complete) {
        BetaCraftHandler.requestV2ServerList(complete, Throwable::printStackTrace);
    }

    public static void requestV2ServerList(Consumer<BCServerList> complete, Consumer<Throwable> throwableConsumer) {
        BetaCraftHandler.requestServerList(BCServerListRequest.V2, complete, throwableConsumer);
    }

    @Deprecated
    public static void requestV1ServerList(Consumer<BCServerList> complete) {
        BetaCraftHandler.requestV1ServerList(complete, Throwable::printStackTrace);
    }

    @Deprecated
    public static void requestV1ServerList(Consumer<BCServerList> complete, Consumer<Throwable> throwableConsumer) {
        BetaCraftHandler.requestServerList(BCServerListRequest.V1, complete, throwableConsumer);
    }

    private static void requestServerList(BCServerListRequest request, Consumer<BCServerList> complete, Consumer<Throwable> throwableConsumer) {
        request.send(HttpClientUtils.HTTP_CLIENT, ClassiCubeHandler.GSON).whenComplete((bcServerList, throwable) -> {
            if (throwable != null) {
                throwableConsumer.accept((Throwable)throwable);
                return;
            }
            complete.accept((BCServerList)bcServerList);
        });
    }

    private static String sha1(byte[] input) {
        try {
            byte[] hash;
            Formatter formatter = new Formatter();
            for (byte b : hash = MessageDigest.getInstance("SHA-1").digest(input)) {
                formatter.format("%02x", b);
            }
            return formatter.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

