/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.classic4j.model.betacraft;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import de.florianmichael.classic4j.model.betacraft.BCServerInfoSpec;
import de.florianmichael.classic4j.model.betacraft.BCVersionCategory;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public record BCServerList(List<BCServerInfoSpec> servers) {
    private final List<BCServerInfoSpec> servers;

    public static CompletableFuture<BCServerList> get(HttpClient httpClient, Gson gson, URI uri, Class<? extends BCServerInfoSpec> infoSpec) {
        return CompletableFuture.supplyAsync(() -> new BCServerList(((JsonArray)gson.fromJson(httpClient.sendAsync(HttpRequest.newBuilder(uri).build(), HttpResponse.BodyHandlers.ofString()).join().body(), JsonArray.class)).asList().stream().map(element -> (BCServerInfoSpec)gson.fromJson(element, infoSpec)).toList()));
    }

    public List<BCServerInfoSpec> servers() {
        return Collections.unmodifiableList(this.servers);
    }

    public List<BCServerInfoSpec> serversOfVersionCategory(BCVersionCategory version) {
        List<BCServerInfoSpec> serverListCopy = this.servers();
        return serverListCopy.stream().filter(s -> s.versionCategory().equals((Object)version)).toList();
    }

    public List<BCServerInfoSpec> serversWithOnlineMode(boolean on) {
        return this.servers().stream().filter(s -> s.onlineMode() == on).toList();
    }

    public List<BCServerInfoSpec> withConnectVersion(String connectVersion) {
        return this.servers().stream().filter(s -> s.connectVersion().equals(connectVersion)).toList();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BCServerList that = (BCServerList)o;
        return Objects.equals(this.servers, that.servers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.servers);
    }

    @Override
    public String toString() {
        return "BCServerList{servers=" + this.servers + "}";
    }
}

