/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.classic4j.request.classicube.auth;

import de.florianmichael.classic4j.ClassiCubeHandler;
import de.florianmichael.classic4j.model.classicube.CCAuthenticationResponse;
import de.florianmichael.classic4j.model.classicube.account.CCAccount;
import de.florianmichael.classic4j.model.classicube.account.CCAuthenticationData;
import de.florianmichael.classic4j.util.HttpClientUtils;
import de.florianmichael.classic4j.util.Parameter;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;

public class CCAuthenticationLoginRequest {
    public static CompletableFuture<CCAuthenticationResponse> send(HttpClient client, CCAccount account, CCAuthenticationResponse previousResponse, String loginCode) {
        return CompletableFuture.supplyAsync(() -> {
            CCAuthenticationData authenticationData = new CCAuthenticationData(account.username(), account.password(), previousResponse.token, loginCode);
            String requestBody = HttpClientUtils.createRequestBody(new Parameter("username", authenticationData.username()), new Parameter("password", authenticationData.password()), new Parameter("token", authenticationData.previousToken()), new Parameter("login_code", authenticationData.loginCode()));
            HttpRequest request = HttpClientUtils.buildWithCookies(account.cookieStore, HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(requestBody)).uri(ClassiCubeHandler.AUTHENTICATION_URI).header("content-type", "application/x-www-form-urlencoded"));
            HttpResponse<String> response = client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).join();
            HttpClientUtils.updateCookies(account.cookieStore, response);
            String responseBody = response.body();
            return CCAuthenticationResponse.fromJson(responseBody);
        });
    }
}

