/*
 * Decompiled with CFR 0.152.
 */
package de.fluxparticle.fenja;

import de.fluxparticle.fenja.Value;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingPropertyException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.stage.Window;
import javafx.util.Duration;
import nz.sodium.Handler;
import nz.sodium.Lambda0;
import nz.sodium.Lambda1;
import nz.sodium.Lambda2;
import nz.sodium.Lazy;
import nz.sodium.Operational;
import nz.sodium.Stream;
import nz.sodium.StreamSink;
import nz.sodium.Unit;

public class EventStream<T> {
    final Stream<T> stream;

    public static <T> EventStream<T> never() {
        return new EventStream<T>(new Stream());
    }

    public static <T extends Event> EventStream<T> streamOf(Node node, EventType<T> eventType) {
        StreamSink sink = new StreamSink();
        node.addEventHandler(eventType, arg_0 -> ((StreamSink)sink).send(arg_0));
        return new EventStream<T>(sink);
    }

    public static <T extends Event> EventStream<T> streamOf(Window window, EventType<T> eventType) {
        StreamSink sink = new StreamSink();
        window.addEventHandler(eventType, arg_0 -> ((StreamSink)sink).send(arg_0));
        return new EventStream<T>(sink);
    }

    public static EventStream<Unit> ticker(Duration duration) {
        StreamSink ticker = new StreamSink();
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(duration, event -> ticker.send((Object)Unit.UNIT), new KeyValue[0])});
        timeline.setCycleCount(-1);
        timeline.play();
        return new EventStream<Unit>((Stream<Unit>)ticker);
    }

    EventStream(Stream<T> stream) {
        this.stream = stream;
    }

    public void listen(Handler<T> handler) {
        this.stream.listen(handler);
    }

    public void listenOnce(Handler<T> handler) {
        this.stream.listenOnce(handler);
    }

    public void listenWeak(Handler<T> handler) {
        this.stream.listenWeak(handler);
    }

    public <R> EventStream<R> constant(R value) {
        return new EventStream<T>(this.stream.mapTo(value));
    }

    public <R> EventStream<R> map(Closure<R> closure) {
        EventStream.modifyClosure(closure);
        return this.map(arg_0 -> closure.call(arg_0));
    }

    public <R> EventStream<R> map(Lambda1<T, R> function) {
        return new EventStream<T>(this.stream.map(function));
    }

    public Value<T> hold(T init) {
        return new Value(this.stream.hold(init));
    }

    public Value<T> holdLazy(Closure<T> init) {
        EventStream.modifyClosure(init);
        return this.holdLazy(() -> init.call());
    }

    public Value<T> holdLazy(Lambda0<T> init) {
        Lazy lazy = new Lazy(init);
        return new Value(this.stream.holdLazy(lazy));
    }

    public <R> EventStream<R> snapshot(Value<R> value) {
        return new EventStream<T>(this.stream.snapshot(value.cell));
    }

    public EventStream<T> multiply(EventStream<T> other) {
        return this.orElse(other);
    }

    public EventStream<T> orElse(EventStream<T> other) {
        return new EventStream<T>(this.stream.orElse(other.stream));
    }

    public Closure<EventStream<T>> power(final EventStream<T> other) {
        return new Closure<EventStream<T>>(this){

            public EventStream<T> doCall(Lambda2<T, T, T> lambda) {
                return EventStream.this.merge(other, lambda);
            }
        };
    }

    public EventStream<T> merge(EventStream<T> other, Lambda2<T, T, T> lambda) {
        return new EventStream<T>(this.stream.merge(other.stream, lambda));
    }

    public static <T> EventStream<T> mergeAll(Iterable<EventStream<T>> streams, Lambda2<T, T, T> lambda) {
        List streamList = StreamSupport.stream(streams.spliterator(), false).map((? super T s) -> s.stream).collect(Collectors.toList());
        return new EventStream<T>(Stream.merge(streamList, lambda));
    }

    public EventStream<T> filter(Closure<Boolean> predicate) {
        EventStream.modifyClosure(predicate);
        return this.filter(arg_0 -> predicate.call(arg_0));
    }

    public EventStream<T> filter(Lambda1<T, Boolean> predicate) {
        return new EventStream<T>(this.stream.filter(predicate));
    }

    public static <T> EventStream<T> filterOptional(EventStream<Optional<T>> optionalStream) {
        return new EventStream<T>(Stream.filterOptional(optionalStream.stream));
    }

    public EventStream<T> gate(Value<Boolean> value) {
        return new EventStream<T>(this.stream.gate(value.cell));
    }

    public <S> Value<S> accum(S init, Closure<S> function) {
        return new Value(this.stream.accum(init, (t, s) -> function.call(new Object[]{t, s})));
    }

    public <S> Value<S> accum(S init, Lambda2<T, S, S> function) {
        return new Value(this.stream.accum(init, function));
    }

    public EventStream<T> defer() {
        return new EventStream<T>(Operational.defer(this.stream));
    }

    public static <A, C extends Iterable<A>> EventStream<A> split(EventStream<C> iterableStream) {
        return new EventStream(Operational.split(iterableStream.stream));
    }

    private static <R> void modifyClosure(Closure<R> closure) {
        Closure outerClosure = (Closure)closure.getOwner();
        final GroovyObject owner = (GroovyObject)outerClosure.getOwner();
        final GroovyObject delegate = (GroovyObject)outerClosure.getDelegate();
        closure.setResolveStrategy(3);
        closure.setDelegate((Object)new GroovyObjectSupport(){

            public Object propertyMissing(String name) {
                try {
                    return owner.getProperty(name);
                }
                catch (MissingPropertyException e) {
                    return ((Value)((Object)delegate.getProperty(name))).sample();
                }
            }
        });
    }
}

