/*
 * Decompiled with CFR 0.152.
 */
package de.fluxparticle.fenja;

import com.ajjpj.afoundation.collection.immutable.AMapEntry;
import com.ajjpj.afoundation.collection.immutable.ARedBlackTreeMap;
import com.ajjpj.afoundation.collection.immutable.ASortedMap;
import com.ajjpj.afoundation.function.AFunction1;
import de.fluxparticle.fenja.EventStream;
import de.fluxparticle.fenja.Value;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;
import nz.sodium.Operational;
import nz.sodium.Stream;
import org.apache.commons.beanutils.BeanUtils;

public class TreeMapValue<K extends Comparable<K>, V>
extends Value<ASortedMap<K, V>> {
    private ObservableValuesList observableValuesList;
    private ObservableEntriesList observableEntriesList;
    private final EventStream<Map<K, V>> sChanges;

    public static Integer nextIndex(ASortedMap<Integer, ?> map) {
        return (Integer)map.last().map((AFunction1 & Serializable)entry -> (Integer)entry.getKey() + 1).getOrElse((Object)0);
    }

    private static <K extends Comparable<K>, V> ASortedMap<K, V> empty() {
        return ARedBlackTreeMap.empty(Comparable::compareTo);
    }

    private static <K extends Comparable<K>, V> ASortedMap<K, V> copy(Map<K, V> orig) {
        ASortedMap result = TreeMapValue.empty();
        for (Map.Entry<K, V> entry : orig.entrySet()) {
            result = result.updated(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K extends Comparable<K>, V> ASortedMap<K, V> apply(Map<K, V> change, ASortedMap<K, V> map) {
        for (Map.Entry<K, V> entry : change.entrySet()) {
            Comparable key = (Comparable)entry.getKey();
            V value = entry.getValue();
            if (value == null) {
                map = map.removed((Object)key);
                continue;
            }
            if (value instanceof Map) {
                Object oldValue = map.getRequired((Object)key);
                Object newValue = TreeMapValue.patchObject(oldValue, (Map)value);
                map = map.updated((Object)key, newValue);
                continue;
            }
            map = map.updated((Object)key, value);
        }
        return map;
    }

    private static <V> V patchObject(V oldValue, Map map) {
        try {
            Object cloneValue = BeanUtils.cloneBean(oldValue);
            BeanUtils.populate((Object)cloneValue, (Map)map);
            return (V)cloneValue;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TreeMapValue(EventStream<Map<K, V>> sChanges, Map<K, V> init) {
        this(sChanges, TreeMapValue.copy(init));
    }

    private TreeMapValue(EventStream<Map<K, V>> sChanges, ASortedMap<K, V> init) {
        super(sChanges.stream.accum(init, TreeMapValue::apply));
        this.sChanges = sChanges;
    }

    public TreeMapValue<K, V> filterByValue(Predicate<V> predicate) {
        EventStream<Map<K, V>> sFilteredChanges = new EventStream<Map<K, V>>(this.sChanges.stream.map(change -> TreeMapValue.filterChangeByValue(predicate, change)));
        ASortedMap init = TreeMapValue.empty();
        for (AMapEntry entry : (ASortedMap)this.cell.sample()) {
            if (!predicate.test(entry.getValue())) continue;
            init = init.updated(entry.getKey(), entry.getValue());
        }
        return new TreeMapValue<K, V>(sFilteredChanges, init);
    }

    public ObservableList<V> valuesAsList() {
        if (this.observableValuesList == null) {
            this.observableValuesList = new ObservableValuesList();
        }
        return this.observableValuesList;
    }

    public ObservableList<Map.Entry<K, V>> entriesAsList() {
        if (this.observableEntriesList == null) {
            this.observableEntriesList = new ObservableEntriesList();
        }
        return this.observableEntriesList;
    }

    private AMapEntry<K, V> getEntry(int index) {
        Iterator iterator = ((ASortedMap)this.cell.sample()).iterator();
        for (int count = index; count >= 0 && iterator.hasNext(); --count) {
            AMapEntry cur = (AMapEntry)iterator.next();
            if (count != 0) continue;
            return cur;
        }
        throw new NoSuchElementException("index=" + index);
    }

    private static <K, V> int getIndex(ASortedMap<K, V> map, K key) {
        int index = 0;
        for (AMapEntry entry : map.toE(key)) {
            ++index;
        }
        return index;
    }

    private static <K extends Comparable<K>, V> Map<K, V> filterChangeByValue(Predicate<V> predicate, Map<K, V> change) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : change.entrySet()) {
            V value = entry.getValue();
            if (value != null && !predicate.test(value)) {
                value = null;
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }

    private class ObservableValuesList
    extends MyObservableListBase<V> {
        private ObservableValuesList() {
        }

        public V get(int index) {
            return TreeMapValue.this.getEntry(index).getValue();
        }
    }

    private class ObservableEntriesList
    extends MyObservableListBase<Map.Entry<K, V>> {
        private ObservableEntriesList() {
        }

        public Map.Entry<K, V> get(int index) {
            AMapEntry aMapEntry = TreeMapValue.this.getEntry(index);
            return new AbstractMap.SimpleImmutableEntry<Object, Object>(aMapEntry.getKey(), aMapEntry.getValue());
        }
    }

    private abstract class MyObservableListBase<T>
    extends ObservableListBase<T> {
        private MyObservableListBase() {
            Operational.defer((Stream)((TreeMapValue)TreeMapValue.this).sChanges.stream.map(changes -> {
                ASortedMap oldMap = (ASortedMap)TreeMapValue.this.cell.sample();
                ArrayList<AbstractMap.SimpleImmutableEntry<Integer, Integer>> changeList = new ArrayList<AbstractMap.SimpleImmutableEntry<Integer, Integer>>();
                for (Map.Entry entry : changes.entrySet()) {
                    int index;
                    boolean delete;
                    Comparable key = (Comparable)entry.getKey();
                    boolean exists = oldMap.containsKey((Object)key);
                    boolean bl = delete = entry.getValue() == null;
                    if (delete) {
                        if (!exists) continue;
                        index = TreeMapValue.getIndex(oldMap, key);
                        changeList.add(new AbstractMap.SimpleImmutableEntry<Integer, Integer>(index, -1));
                        oldMap = oldMap.removed((Object)key);
                        continue;
                    }
                    if (exists) {
                        index = TreeMapValue.getIndex(oldMap, key);
                        changeList.add(new AbstractMap.SimpleImmutableEntry<Integer, Integer>(index, 0));
                        continue;
                    }
                    oldMap = oldMap.updated((Object)key, null);
                    index = TreeMapValue.getIndex(oldMap, key);
                    changeList.add(new AbstractMap.SimpleImmutableEntry<Integer, Integer>(index, 1));
                }
                return changeList;
            })).listen(changeList -> {
                this.beginChange();
                for (Map.Entry entry : changeList) {
                    int index = (Integer)entry.getKey();
                    int op = (Integer)entry.getValue();
                    if (op < 0) {
                        this.nextRemove(index, null);
                        continue;
                    }
                    if (op > 0) {
                        this.nextAdd(index, index + 1);
                        continue;
                    }
                    this.nextUpdate(index);
                }
                this.endChange();
            });
        }

        public int size() {
            return ((ASortedMap)TreeMapValue.this.cell.sample()).size();
        }
    }
}

