/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql;

import de.foellix.aql.Properties;
import de.foellix.aql.ui.gui.BottomEditor;
import de.foellix.aql.ui.gui.GUI;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.fusesource.jansi.Ansi;

public class Log {
    public static final int NONE = -1;
    public static final int IMPORTANT = 0;
    public static final int ERROR = 1;
    public static final int DEBUG_SPECIAL = 2;
    public static final int WARNING = 3;
    public static final int NORMAL = 4;
    public static final int DEBUG = 5;
    public static final int DEBUG_DETAILED = 6;
    private static int loglevel = 4;
    private static File logfile = new File("log.txt");
    private static List<String> log = new ArrayList<String>();
    private static boolean prefixEnabled = true;
    private static boolean shorten = false;

    public static void msg(String msg, int loglevel) {
        if (loglevel <= Log.loglevel) {
            System.out.println(Log.prefix(true) + msg);
            if (loglevel == 0) {
                Log.logToGUI(msg);
                Log.logToFile(msg);
            }
        }
    }

    public static void msg(Ansi msg, int loglevel) {
        if (loglevel <= Log.loglevel) {
            System.out.println(Log.prefix(true) + msg);
        }
    }

    public static void warning(String msg) {
        if (!log.contains(msg) && 3 <= loglevel) {
            System.err.println(Log.prefix(true) + Ansi.ansi().fg(Ansi.Color.YELLOW).a("Warning: " + msg).reset());
            Log.logToGUI("Warning: " + msg);
            log.add(msg);
        }
    }

    public static void error(String msg) {
        Log.error(msg, false);
    }

    public static void error(String msg, boolean logToFile) {
        if (!log.contains(msg)) {
            System.err.println(Log.prefix(true) + Ansi.ansi().fg(Ansi.Color.RED).a("Error: " + msg).reset());
            Log.logToGUI("Error: " + msg);
            if (logToFile) {
                Log.logToFile(msg);
            }
            log.add(msg);
        }
    }

    public static void setLogLevel(int loglevel) {
        Log.loglevel = loglevel;
    }

    public static boolean logIt(int loglevel) {
        return loglevel <= Log.loglevel;
    }

    public static void reset() {
        log.clear();
    }

    private static String prefix(boolean nl) {
        if (prefixEnabled) {
            Date date = new Date();
            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy - hh:mm:ss");
            return Properties.info().ABBRRVIATION + " " + format.format(date) + (nl ? "\n" : " ");
        }
        return "";
    }

    public static void setPrefixEnabled(boolean value) {
        prefixEnabled = value;
    }

    private static void logToGUI(String msg) {
        if (GUI.started) {
            BottomEditor.log(msg);
        }
    }

    private static void logToFile(String msg) {
        new Thread(() -> {
            try {
                Files.write(Paths.get(logfile.toURI()), (Log.prefix(false) + msg + "\n").getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                Log.error("Could not wirte logfile: " + logfile.getAbsolutePath());
            }
        }).start();
    }

    public static boolean getShorten() {
        return shorten;
    }

    public static void setShorten(boolean shorten) {
        Log.shorten = shorten;
    }

    public static int getLogLevel() {
        return loglevel;
    }
}

