/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.config;

import de.foellix.aql.Log;
import de.foellix.aql.config.Config;
import de.foellix.aql.config.wizard.ConfigWizard;
import de.foellix.aql.ui.gui.GUI;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class ConfigHandler {
    private File configFile = new File("config.xml");
    private Config config = null;
    private static ConfigHandler instance = new ConfigHandler();
    private boolean offeredWizard = false;

    private ConfigHandler() {
    }

    public static ConfigHandler getInstance() {
        return instance;
    }

    public Config getConfig() {
        return this.getConfig(false);
    }

    public Config getConfig(boolean reload) {
        if (this.config == null || reload) {
            if (this.configFile.exists()) {
                this.config = ConfigHandler.parseXML(this.configFile);
            } else if (!this.offeredWizard) {
                this.offeredWizard = true;
                if (!GUI.showConfigWizard) {
                    this.offerConfigWizard(GUI.stage);
                }
            }
        }
        return this.config;
    }

    public void offerConfigWizard(Stage stage) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        Stage alertStage = (Stage)alert.getDialogPane().getScene().getWindow();
        alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_16.png", 16.0, 16.0, false, true));
        alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_32.png", 32.0, 32.0, false, true));
        alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_64.png", 64.0, 64.0, false, true));
        alert.setTitle("Missing configuration");
        alert.setHeaderText("Configuration file could not be found.");
        alert.setContentText("Do you want to start the configuration wizard?");
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.OK) {
            new ConfigWizard(stage, ConfigHandler.getInstance().getConfigFile());
        } else {
            Log.warning("No configuration specified.");
        }
    }

    public static Config parseXML(File configFile) {
        if (configFile != null) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Config.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                Config config = (Config)jaxbUnmarshaller.unmarshal(configFile);
                return config;
            }
            catch (JAXBException e) {
                Log.error("Something went wrong while reading config file: " + configFile.getAbsolutePath() + " (" + e.getMessage() + ")");
            }
        }
        return null;
    }

    public static Config parseXML(String configString) {
        if (configString != null) {
            try {
                StringReader reader = new StringReader(configString);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Config.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                Config config = (Config)jaxbUnmarshaller.unmarshal((Reader)reader);
                reader.close();
                return config;
            }
            catch (JAXBException e) {
                Log.error("Cannot parse XML document currently. It must be corrupted: " + e.getMessage());
            }
        }
        return null;
    }

    public String toXML() {
        return ConfigHandler.toXML(this.config);
    }

    public static String toXML(Config config) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Config.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.setProperty("jaxb.encoding", (Object)"utf-8");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            jaxbMarshaller.marshal((Object)config, (OutputStream)outputStream);
            String returnStr = ((Object)outputStream).toString();
            ((OutputStream)outputStream).close();
            return returnStr;
        }
        catch (IOException | JAXBException e) {
            Log.error("Something went wrong while creating the XML string (" + e.getMessage() + ").");
            return null;
        }
    }

    public void setConfig(File config) {
        this.configFile = config;
        this.getConfig(true);
    }

    public File getConfigFile() {
        return this.configFile;
    }
}

