/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.config.wizard;

import de.foellix.aql.config.Priority;
import de.foellix.aql.config.Tool;
import de.foellix.aql.config.wizard.Overview;
import de.foellix.aql.ui.gui.FileChooserUIElement;
import de.foellix.aql.ui.gui.FontAwesome;
import java.util.Collection;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class EditorOverview
extends BorderPane {
    private final Overview parent;
    private final Label[] labels = new Label[13];
    private final HelpButton[] helpBtn = new HelpButton[13];
    private final FileChooserUIElement[] texts = new FileChooserUIElement[13];
    private ScrollPane priorityScroll;
    private TableView<Priority> priorityTable;
    private Button addBtn;
    private Tool currentTool;
    private static final String TOOLTIP_TOOL = "Available variables: \r\n\r\n%APP_APK%: .apk file\r\n%APP_APK_FILENAME%: .apk file without path and \".apk\"\r\n%APP_NAME%: App name\r\n%APP_PACKAGE%: App package\r\n%ANDROID_PLATFORMS%: Android platforms folder\r\n%MEMORY%: Memory\r\n%PID%: Process ID";
    private static final String TOOLTIP_PREPROCESSOR = "Available variables: \r\n\r\n%APP_APK%: .apk file\r\n%APP_APK_FILENAME%: .apk file without path and \".apk\"\r\n%APP_NAME%: App name\r\n%APP_PACKAGE%: App package\r\n%ANDROID_PLATFORMS%: Android platforms folder\r\n%MEMORY%: Memory\r\n%PID%: Process ID";
    private static final String TOOLTIP_OPERATOR = "Available variables: \r\n\r\n%ANSWERS%: Input AQL-Answers for operators\r\n%ANSWERSHASH%: SHA-256-hash of %ANSWERS%-String\r\n%MEMORY%: Memory\r\n%PID%: Process ID";
    private static final String TOOLTIP_CONVERTER = "Available variables: \r\n\r\n%RESULT_FILE%: Result file of a tool\r\n%MEMORY%: Memory\r\n%PID%: Process ID";
    private static final String TOOLTIP_EVENT = "Available variables: \r\n\r\n%MEMORY%: Memory\r\n%PID%: Process ID";

    EditorOverview(Overview parent) {
        this.parent = parent;
        ScrollPane scrollBox = new ScrollPane();
        scrollBox.setFitToWidth(true);
        VBox editorBox = new VBox(5.0);
        editorBox.setPadding(new Insets(10.0));
        this.labels[0] = new Label("Name:");
        this.labels[1] = new Label("Version:");
        this.labels[2] = new Label();
        this.labels[3] = new Label("Priority:");
        this.labels[4] = new Label("Instances (0 = \u221e):");
        this.labels[5] = new Label("Memory per instance (in GB):");
        this.labels[6] = new Label("Path: ");
        this.helpBtn[6] = new HelpButton("Available variables: \r\n\r\n%APP_APK%: .apk file\r\n%APP_APK_FILENAME%: .apk file without path and \".apk\"\r\n%APP_NAME%: App name\r\n%APP_PACKAGE%: App package\r\n%ANDROID_PLATFORMS%: Android platforms folder\r\n%MEMORY%: Memory\r\n%PID%: Process ID");
        this.labels[7] = new Label("Run: ");
        this.helpBtn[7] = new HelpButton("Available variables: \r\n\r\n%APP_APK%: .apk file\r\n%APP_APK_FILENAME%: .apk file without path and \".apk\"\r\n%APP_NAME%: App name\r\n%APP_PACKAGE%: App package\r\n%ANDROID_PLATFORMS%: Android platforms folder\r\n%MEMORY%: Memory\r\n%PID%: Process ID");
        this.labels[8] = new Label("Result: ");
        this.helpBtn[8] = new HelpButton("Available variables: \r\n\r\n%APP_APK%: .apk file\r\n%APP_APK_FILENAME%: .apk file without path and \".apk\"\r\n%APP_NAME%: App name\r\n%APP_PACKAGE%: App package\r\n%ANDROID_PLATFORMS%: Android platforms folder\r\n%MEMORY%: Memory\r\n%PID%: Process ID");
        this.labels[9] = new Label("Run on Abort: ");
        this.helpBtn[9] = new HelpButton(TOOLTIP_EVENT);
        this.labels[10] = new Label("Run on Fail: ");
        this.helpBtn[10] = new HelpButton(TOOLTIP_EVENT);
        this.labels[11] = new Label("Run on Success: ");
        this.helpBtn[11] = new HelpButton(TOOLTIP_EVENT);
        this.labels[12] = new Label("Run on Exit: ");
        this.helpBtn[12] = new HelpButton(TOOLTIP_EVENT);
        for (int i = 0; i <= 8; ++i) {
            if (i != 3) {
                this.texts[i] = i >= 6 ? new FileChooserUIElement(parent.getParentGUI().getStage(), "Browse...") : new FileChooserUIElement(parent.getParentGUI().getStage(), null);
                if (i >= 4 && i <= 5) {
                    this.texts[i].setNumeric();
                }
                if (i == 6) {
                    this.texts[i].setFolder();
                }
                if (this.helpBtn[i] != null) {
                    FlowPane helpPane = new FlowPane();
                    helpPane.getChildren().addAll((Object[])new Node[]{this.labels[i], this.helpBtn[i]});
                    editorBox.getChildren().addAll((Object[])new Node[]{helpPane, this.texts[i]});
                    continue;
                }
                editorBox.getChildren().addAll((Object[])new Node[]{this.labels[i], this.texts[i]});
                continue;
            }
            BorderPane priorityBox = new BorderPane();
            this.priorityTable = new TableView();
            this.priorityTable.setEditable(true);
            TableColumn colValue = new TableColumn("Value");
            colValue.setCellValueFactory((Callback)new PropertyValueFactory("value"));
            colValue.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new StringConverter<Integer>(){

                public String toString(Integer object) {
                    return object.toString();
                }

                public Integer fromString(String string) {
                    return Integer.valueOf(string);
                }
            }));
            colValue.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Priority, Integer>>(){

                public void handle(TableColumn.CellEditEvent<Priority, Integer> t) {
                    ((Priority)t.getTableView().getItems().get(t.getTablePosition().getRow())).setValue((Integer)t.getNewValue());
                }
            });
            TableColumn colFeature = new TableColumn("Feature");
            colFeature.setCellValueFactory((Callback)new PropertyValueFactory("feature"));
            colFeature.setCellFactory(TextFieldTableCell.forTableColumn());
            colFeature.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Priority, String>>(){

                public void handle(TableColumn.CellEditEvent<Priority, String> t) {
                    ((Priority)t.getTableView().getItems().get(t.getTablePosition().getRow())).setFeature((String)t.getNewValue());
                }
            });
            this.priorityTable.getColumns().addAll((Object[])new TableColumn[]{colValue, colFeature});
            this.priorityScroll = new ScrollPane(this.priorityTable);
            this.priorityScroll.setFitToWidth(true);
            this.priorityScroll.setMaxHeight(95.0);
            this.addBtn = new Button("Add");
            this.addBtn.setOnAction(eh -> this.priorityTable.getItems().add((Object)new Priority()));
            this.addBtn.setMaxHeight(95.0);
            priorityBox.setCenter((Node)this.priorityScroll);
            priorityBox.setRight((Node)this.addBtn);
            editorBox.getChildren().addAll((Object[])new Node[]{this.labels[i], priorityBox});
        }
        VBox runOnEventBox = new VBox(5.0);
        TitledPane runOnEventRoot = new TitledPane("Run on Event", (Node)runOnEventBox);
        runOnEventRoot.setExpanded(false);
        for (int i = 9; i <= 12; ++i) {
            this.texts[i] = new FileChooserUIElement(parent.getParentGUI().getStage(), "Browse...");
            if (this.helpBtn[i] != null) {
                FlowPane helpPane = new FlowPane();
                helpPane.getChildren().addAll((Object[])new Node[]{this.labels[i], this.helpBtn[i]});
                runOnEventBox.getChildren().addAll((Object[])new Node[]{helpPane, this.texts[i]});
                continue;
            }
            runOnEventBox.getChildren().addAll((Object[])new Node[]{this.labels[i], this.texts[i]});
        }
        editorBox.getChildren().addAll((Object[])new Node[]{new Label(), runOnEventRoot});
        scrollBox.setContent((Node)editorBox);
        Button applyBtn = new Button("Apply");
        BorderPane applyPane = new BorderPane();
        applyPane.setRight((Node)applyBtn);
        applyPane.setPadding(new Insets(10.0));
        applyBtn.setOnAction(eh -> this.apply());
        this.setBottom((Node)applyPane);
        this.setCenter((Node)scrollBox);
    }

    public void load(Tool tool, int type) {
        if (tool != null && tool.getName() != null) {
            this.currentTool = tool;
            boolean toggle = type == 3;
            this.labels[2].setText(Overview.typeToString(type) + " (separated by \",\")");
            this.helpBtn[6].setToolTip(EditorOverview.typeToToolTip(type));
            this.helpBtn[7].setToolTip(EditorOverview.typeToToolTip(type));
            this.helpBtn[8].setToolTip(EditorOverview.typeToToolTip(type));
            this.texts[0].getTextField().setText(tool.getName());
            this.texts[1].getTextField().setText(tool.getVersion());
            this.texts[2].getTextField().setText(tool.getQuestions());
            this.priorityScroll.setDisable(toggle);
            this.addBtn.setDisable(toggle);
            this.priorityTable.setDisable(toggle);
            this.priorityTable.getItems().setAll(tool.getPriority());
            this.texts[4].setDisable(toggle);
            this.texts[4].getTextField().setText(String.valueOf(tool.getInstances()));
            this.texts[5].getTextField().setText(String.valueOf(tool.getMemoryPerInstance()));
            this.texts[6].getTextField().setText(tool.getPath());
            this.texts[7].getTextField().setText(tool.getRun());
            this.texts[8].getTextField().setText(tool.getResult());
            this.texts[9].setDisable(toggle);
            this.texts[10].setDisable(toggle);
            this.texts[11].setDisable(toggle);
            this.texts[12].setDisable(toggle);
            this.texts[9].getTextField().setText(tool.getRunOnAbort());
            this.texts[10].getTextField().setText(tool.getRunOnFail());
            this.texts[11].getTextField().setText(tool.getRunOnSuccess());
            this.texts[12].getTextField().setText(tool.getRunOnExit());
        }
    }

    private void apply() {
        this.currentTool.setName(this.texts[0].getTextField().getText());
        this.currentTool.setVersion(this.texts[1].getTextField().getText());
        this.currentTool.setQuestions(this.texts[2].getTextField().getText());
        this.currentTool.getPriority().clear();
        this.currentTool.getPriority().addAll((Collection<Priority>)this.priorityTable.getItems());
        this.currentTool.setInstances(Integer.parseInt(this.texts[4].getTextField().getText()));
        this.currentTool.setMemoryPerInstance(Integer.parseInt(this.texts[5].getTextField().getText()));
        this.currentTool.setPath(this.texts[6].getTextField().getText());
        this.currentTool.setRun(this.texts[7].getTextField().getText());
        this.currentTool.setResult(this.texts[8].getTextField().getText());
        this.currentTool.setRunOnAbort(this.texts[9].getTextField().getText());
        this.currentTool.setRunOnFail(this.texts[10].getTextField().getText());
        this.currentTool.setRunOnSuccess(this.texts[11].getTextField().getText());
        this.currentTool.setRunOnExit(this.texts[12].getTextField().getText());
        this.parent.apply();
    }

    private static String typeToToolTip(int type) {
        if (type == 0) {
            return "Available variables: \r\n\r\n%APP_APK%: .apk file\r\n%APP_APK_FILENAME%: .apk file without path and \".apk\"\r\n%APP_NAME%: App name\r\n%APP_PACKAGE%: App package\r\n%ANDROID_PLATFORMS%: Android platforms folder\r\n%MEMORY%: Memory\r\n%PID%: Process ID";
        }
        if (type == 1) {
            return "Available variables: \r\n\r\n%APP_APK%: .apk file\r\n%APP_APK_FILENAME%: .apk file without path and \".apk\"\r\n%APP_NAME%: App name\r\n%APP_PACKAGE%: App package\r\n%ANDROID_PLATFORMS%: Android platforms folder\r\n%MEMORY%: Memory\r\n%PID%: Process ID";
        }
        if (type == 2) {
            return TOOLTIP_OPERATOR;
        }
        if (type == 3) {
            return TOOLTIP_CONVERTER;
        }
        return "UNKNOWN TYPE";
    }

    private class HelpButton
    extends Button {
        String toolTip;

        HelpButton(String toolTip) {
            super("?");
            this.toolTip = toolTip;
            this.setTooltip(new Tooltip(toolTip));
            FontAwesome.getInstance().setBlue(this);
            this.setOnAction(eh -> this.showToolTip());
        }

        private void showToolTip() {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            Stage alertStage = (Stage)alert.getDialogPane().getScene().getWindow();
            alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_16.png", 16.0, 16.0, false, true));
            alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_32.png", 32.0, 32.0, false, true));
            alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_64.png", 64.0, 64.0, false, true));
            alert.setTitle("Help");
            alert.setHeaderText(this.toolTip.substring(0, this.toolTip.indexOf("\r\n")));
            String text = this.toolTip.substring(this.toolTip.indexOf("\r\n") + 4);
            TextArea textArea = new TextArea(text);
            textArea.setEditable(false);
            textArea.setPrefHeight((double)text.split("\r\n").length * 17.0 + 10.0);
            textArea.setWrapText(true);
            BorderPane content = new BorderPane();
            content.setCenter((Node)textArea);
            alert.getDialogPane().setContent((Node)content);
            alert.showAndWait();
        }

        public void setToolTip(String toolTip) {
            this.toolTip = toolTip;
        }
    }
}

