/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.config.wizard;

import de.foellix.aql.config.wizard.ConfigWizard;
import de.foellix.aql.ui.gui.FileChooserUIElement;
import de.foellix.aql.ui.gui.FontAwesome;
import de.foellix.aql.ui.gui.MenuFile;
import de.foellix.aql.ui.gui.MenuHelp;
import de.foellix.aql.ui.gui.ToolsetFile;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class Menubar
extends VBox {
    private final ConfigWizard parent;
    private final FileChooserUIElement maxMemChooser;
    private final FileChooserUIElement fileChooserUIElement;

    Menubar(final ConfigWizard parent) {
        this.parent = parent;
        MenuBar menuBar = new MenuBar();
        Menu menuEdit = new Menu("Edit");
        MenuItem menuItemUndo = FontAwesome.getInstance().createMenuItem("\uf0e2", "Undo");
        menuItemUndo.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemUndo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.undo();
            }
        });
        MenuItem menuItemRedo = FontAwesome.getInstance().createMenuItem("\uf01e", "Redo");
        menuItemRedo.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Y, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemRedo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.redo();
            }
        });
        SeparatorMenuItem sep1 = new SeparatorMenuItem();
        MenuItem menuItemAutoFormat = FontAwesome.getInstance().createMenuItem("\uf03c", "Auto Format");
        menuItemAutoFormat.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.autoformat();
            }
        });
        SeparatorMenuItem sep2 = new SeparatorMenuItem();
        MenuItem menuItemAddTool = FontAwesome.getInstance().createMenuItem("\uf067", "Add new tool");
        menuItemAddTool.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.addTool();
            }
        });
        SeparatorMenuItem sep3 = new SeparatorMenuItem();
        MenuItem menuItemContinue = FontAwesome.getInstance().createMenuItem("\uf04b", "Continue with this configuration");
        menuItemContinue.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.continueWithCurrentConfig();
            }
        });
        menuEdit.getItems().addAll((Object[])new MenuItem[]{menuItemUndo, menuItemRedo, sep1, menuItemAutoFormat, sep2, menuItemAddTool, sep3, menuItemContinue});
        menuBar.getMenus().addAll((Object[])new Menu[]{new MenuFile(parent), menuEdit, new MenuHelp(null).removeConfigWizard()});
        ToolBar toolBar = new ToolBar();
        Separator sep4 = new Separator();
        Button btnAutoFormat = FontAwesome.getInstance().createButton("\uf03c");
        btnAutoFormat.setTooltip(new Tooltip("Auto Format"));
        btnAutoFormat.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.autoformat();
            }
        });
        Separator sep5 = new Separator();
        Button btnAddTool = FontAwesome.getInstance().createButton("\uf067");
        btnAddTool.setTooltip(new Tooltip("Add new tool"));
        btnAddTool.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.addTool();
            }
        });
        FontAwesome.getInstance().setGreen(btnAddTool);
        HBox spacer = new HBox();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        Label labelMaxMem = new Label("Max. memory: ");
        this.maxMemChooser = new FileChooserUIElement(parent.getStage(), null);
        this.maxMemChooser.setNumeric();
        this.maxMemChooser.getTextField().setPrefWidth(50.0);
        this.maxMemChooser.getTextField().textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals("")) {
                parent.getConfig().setMaxMemory(Integer.parseInt(newValue));
                parent.syncEditorXML();
            }
        });
        Label labelAndroidSDK = new Label("   Android Platforms: ");
        this.fileChooserUIElement = new FileChooserUIElement(parent.getStage(), "Browse...");
        this.fileChooserUIElement.getTextField().setPrefWidth(200.0);
        this.fileChooserUIElement.getTextField().textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals("")) {
                parent.getConfig().setAndroidPlatforms((String)newValue);
                parent.syncEditorXML();
            }
        });
        this.fileChooserUIElement.setFolder();
        Separator sep6 = new Separator();
        Button btnContinue = FontAwesome.getInstance().createButton("\uf04b");
        btnContinue.setTooltip(new Tooltip("Continue with this configuration"));
        btnContinue.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.continueWithCurrentConfig();
            }
        });
        FontAwesome.getInstance().setGreen(btnContinue);
        toolBar.getItems().addAll((Object[])new Node[]{new ToolsetFile(parent), sep4, btnAutoFormat, sep5, btnAddTool, spacer, labelMaxMem, this.maxMemChooser, labelAndroidSDK, this.fileChooserUIElement, sep6, btnContinue});
        this.sync();
        this.getChildren().addAll((Object[])new Node[]{menuBar, toolBar});
    }

    public void sync() {
        if (this.parent.getConfig().getMaxMemory() > 0) {
            this.maxMemChooser.getTextField().setText(String.valueOf(this.parent.getConfig().getMaxMemory()));
        }
        if (this.parent.getConfig().getAndroidPlatforms() != null) {
            this.fileChooserUIElement.getTextField().setText(this.parent.getConfig().getAndroidPlatforms());
        }
    }
}

