/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.converter;

import de.foellix.aql.Log;
import de.foellix.aql.config.Tool;
import de.foellix.aql.converter.IConverter;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.datastructure.handler.ParseException;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.task.TaskInfo;
import de.foellix.aql.system.task.ToolTaskInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;

public class ExternalConverter
extends Thread
implements IConverter {
    private final Tool converter;
    private File resultFile;
    private ToolTaskInfo taskInfo;
    private Answer answer;

    public ExternalConverter(Tool converter) {
        this.converter = converter;
    }

    @Override
    public void run() {
        try {
            Log.msg("Executing external Converter: " + this.converter.getName() + " (" + Helper.replaceVariables(this.converter.getRun(), this.taskInfo, this.resultFile) + ")", 4);
            String[] runCmd = Helper.replaceVariables(this.converter.getRun(), this.taskInfo, this.resultFile).split(" ");
            String path = Helper.replaceVariables(this.taskInfo.getTool().getPath(), this.taskInfo, this.resultFile);
            Process process = new ProcessBuilder(runCmd).directory(new File(path)).start();
            if (Log.logIt(6)) {
                String line;
                BufferedReader input1 = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = input1.readLine()) != null) {
                    Log.msg("Process (output): " + line, 6);
                }
                input1.close();
                BufferedReader input2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((line = input2.readLine()) != null) {
                    Log.msg("Process (error): " + line, 6);
                }
                input2.close();
            } else {
                process.getErrorStream().close();
                process.getOutputStream().close();
            }
            if (process.waitFor() != 0) {
                throw new ParseException("Process finished unsuccessfully.");
            }
            File result = Helper.findFileWithAsterisk(new File(Helper.replaceVariables(this.converter.getResult(), (TaskInfo)this.taskInfo, this.taskInfo.getQuestion())));
            Helper.waitForResult("Result file was not generated. " + this.converter.getName() + " converter may have not finished properly.", result);
            this.answer = AnswerHandler.parseXML(result);
            Log.msg("External converter finished successfully: " + this.converter.getName() + " (" + Helper.replaceVariables(this.converter.getRun(), this.taskInfo, this.resultFile) + ")", 4);
        }
        catch (Exception e) {
            Log.error("External converter:\n" + Helper.toString(this.converter) + "\nexecution failed! Replying empty answer! (" + e.getMessage() + ")");
            this.answer = new Answer();
        }
    }

    @Override
    public Answer parse(File resultFile, ToolTaskInfo taskInfo) throws Exception {
        this.resultFile = resultFile;
        this.taskInfo = taskInfo;
        this.answer = null;
        this.start();
        while (this.answer == null) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                if (this.answer != null) continue;
                Log.error("Error occured while waiting for converter process to end: " + Helper.toString(this.converter) + " (" + e.getMessage() + ")");
                return new Answer();
            }
        }
        return this.answer;
    }
}

