/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.converter.ic3;

import de.foellix.aql.Log;
import de.foellix.aql.converter.IConverter;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.Data;
import de.foellix.aql.datastructure.Intent;
import de.foellix.aql.datastructure.Intentfilter;
import de.foellix.aql.datastructure.Intentfilters;
import de.foellix.aql.datastructure.Intents;
import de.foellix.aql.datastructure.Intentsink;
import de.foellix.aql.datastructure.Intentsinks;
import de.foellix.aql.datastructure.Intentsource;
import de.foellix.aql.datastructure.Intentsources;
import de.foellix.aql.datastructure.QuestionPart;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.Target;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.task.ToolTaskInfo;
import edu.psu.cse.siis.ic3.Ic3Data;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ConverterIC3
implements IConverter {
    @Override
    public Answer parse(File resultFile, ToolTaskInfo taskInfo) {
        Ic3Data.Application app;
        try {
            FileInputStream input = new FileInputStream(resultFile);
            app = Ic3Data.Application.parseFrom(input);
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.error("Error while reading file: " + resultFile.getAbsolutePath());
            return null;
        }
        return this.convert(app, taskInfo.getQuestion());
    }

    private Answer convert(Ic3Data.Application data, QuestionPart question) {
        Answer answer = new Answer();
        Log.msg(data.toString(), 6);
        if (data.getComponentsList() != null && !data.getComponentsList().isEmpty()) {
            answer.setIntentfilters(new Intentfilters());
            for (Ic3Data.Application.Component component : data.getComponentsList()) {
                Reference origin;
                Reference originReduced;
                Ic3Data.Application.Component.Instruction instruction;
                for (Ic3Data.Application.Component.Extra ex : component.getExtrasList()) {
                    instruction = ex.getInstruction();
                    originReduced = new Reference();
                    originReduced.setClassname(instruction.getClassName());
                    originReduced.setApp(question.getReferences().get(0).getApp());
                    origin = new Reference();
                    origin.setStatement(Helper.fromStatementString(instruction.getStatement()));
                    origin.setMethod(instruction.getMethod());
                    origin.setClassname(instruction.getClassName());
                    origin.setApp(question.getReferences().get(0).getApp());
                    if (component.getIntentFiltersList().isEmpty()) continue;
                    for (Ic3Data.Application.Component.IntentFilter intentfilter : component.getIntentFiltersList()) {
                        Intentfilter intentfilterObj = new Intentfilter();
                        intentfilterObj.setReference(originReduced);
                        Data dataObj = null;
                        for (Ic3Data.Attribute attribute : intentfilter.getAttributesList()) {
                            if (attribute.getKind() == Ic3Data.AttributeKind.CATEGORY) {
                                for (String string : attribute.getValueList()) {
                                    intentfilterObj.getCategory().add(string);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.ACTION) {
                                for (String string : attribute.getValueList()) {
                                    intentfilterObj.setAction(string);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.TYPE) {
                                for (String string : attribute.getValueList()) {
                                    if (dataObj == null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setType(string);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.SCHEME) {
                                for (String string : attribute.getValueList()) {
                                    if (dataObj == null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setScheme(string);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.SSP) {
                                for (String string : attribute.getValueList()) {
                                    if (dataObj == null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setSsp(string);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.HOST) {
                                for (String string : attribute.getValueList()) {
                                    if (dataObj == null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setHost(string);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.PORT) {
                                for (String string : attribute.getValueList()) {
                                    if (dataObj == null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setPort(string);
                                }
                                continue;
                            }
                            if (attribute.getKind() != Ic3Data.AttributeKind.PATH) continue;
                            for (String string : attribute.getValueList()) {
                                if (dataObj == null) {
                                    dataObj = new Data();
                                }
                                dataObj.setPath(string);
                            }
                        }
                        if (dataObj != null) {
                            intentfilterObj.setData(dataObj);
                        }
                        answer.getIntentfilters().getIntentfilter().add(intentfilterObj);
                    }
                }
                if (!component.getExtrasList().isEmpty()) {
                    if (answer.getIntentsources() == null) {
                        answer.setIntentsources(new Intentsources());
                    }
                    for (Ic3Data.Application.Component.Extra ex : component.getExtrasList()) {
                        instruction = ex.getInstruction();
                        originReduced = new Reference();
                        originReduced.setClassname(instruction.getClassName());
                        originReduced.setApp(question.getReferences().get(0).getApp());
                        origin = new Reference();
                        origin.setStatement(Helper.fromStatementString(instruction.getStatement()));
                        origin.setMethod(instruction.getMethod());
                        origin.setClassname(instruction.getClassName());
                        origin.setApp(question.getReferences().get(0).getApp());
                        Intentsource intentsourceExp = new Intentsource();
                        intentsourceExp.setReference(origin);
                        Target targetExp = new Target();
                        targetExp.setReference(originReduced);
                        intentsourceExp.setTarget(targetExp);
                        answer.getIntentsources().getIntentsource().add(intentsourceExp);
                        if (component.getIntentFiltersList().isEmpty()) continue;
                        for (Ic3Data.Application.Component.IntentFilter intentfilter : component.getIntentFiltersList()) {
                            Intentsource intentsource = new Intentsource();
                            intentsource.setReference(origin);
                            Target targetImp = new Target();
                            Data dataObj = null;
                            for (Ic3Data.Attribute attribute : intentfilter.getAttributesList()) {
                                if (attribute.getKind() == Ic3Data.AttributeKind.CATEGORY) {
                                    for (String value2 : attribute.getValueList()) {
                                        targetImp.getCategory().add(value2);
                                    }
                                    continue;
                                }
                                if (attribute.getKind() == Ic3Data.AttributeKind.ACTION) {
                                    for (String value : attribute.getValueList()) {
                                        targetImp.setAction(value);
                                    }
                                    continue;
                                }
                                if (attribute.getKind() == Ic3Data.AttributeKind.TYPE) {
                                    for (String value : attribute.getValueList()) {
                                        if (dataObj == null) {
                                            dataObj = new Data();
                                        }
                                        dataObj.setType(value);
                                    }
                                    continue;
                                }
                                if (attribute.getKind() == Ic3Data.AttributeKind.SCHEME) {
                                    for (String value : attribute.getValueList()) {
                                        if (dataObj == null) {
                                            dataObj = new Data();
                                        }
                                        dataObj.setScheme(value);
                                    }
                                    continue;
                                }
                                if (attribute.getKind() == Ic3Data.AttributeKind.SSP) {
                                    for (String value : attribute.getValueList()) {
                                        if (dataObj == null) {
                                            dataObj = new Data();
                                        }
                                        dataObj.setSsp(value);
                                    }
                                    continue;
                                }
                                if (attribute.getKind() == Ic3Data.AttributeKind.HOST) {
                                    for (String value : attribute.getValueList()) {
                                        if (dataObj == null) {
                                            dataObj = new Data();
                                        }
                                        dataObj.setHost(value);
                                    }
                                    continue;
                                }
                                if (attribute.getKind() == Ic3Data.AttributeKind.PORT) {
                                    for (String value : attribute.getValueList()) {
                                        if (dataObj == null) {
                                            dataObj = new Data();
                                        }
                                        dataObj.setPort(value);
                                    }
                                    continue;
                                }
                                if (attribute.getKind() != Ic3Data.AttributeKind.PATH) continue;
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setPath(value);
                                }
                            }
                            if (dataObj != null) {
                                targetImp.setData(dataObj);
                            }
                            intentsource.setTarget(targetImp);
                            answer.getIntentsources().getIntentsource().add(intentsource);
                        }
                    }
                }
                if (component.getExitPointsList().isEmpty()) continue;
                if (answer.getIntents() == null) {
                    answer.setIntents(new Intents());
                }
                if (answer.getIntentsinks() == null) {
                    answer.setIntentsinks(new Intentsinks());
                }
                for (Ic3Data.Application.Component.ExitPoint exitpoint : component.getExitPointsList()) {
                    instruction = exitpoint.getInstruction();
                    Reference origin2 = new Reference();
                    origin2.setStatement(Helper.fromStatementString(instruction.getStatement()));
                    origin2.setMethod(instruction.getMethod());
                    origin2.setClassname(instruction.getClassName());
                    origin2.setApp(question.getReferences().get(0).getApp());
                    for (Ic3Data.Application.Component.ExitPoint.Intent intent : exitpoint.getIntentsList()) {
                        Intent intentObj = new Intent();
                        Intentsink intentsink = new Intentsink();
                        intentObj.setReference(origin2);
                        intentsink.setReference(origin2);
                        Target target = new Target();
                        Reference targetRef = null;
                        Data dataObj = null;
                        for (Ic3Data.Attribute attribute : intent.getAttributesList()) {
                            if (attribute.getKind() == Ic3Data.AttributeKind.CATEGORY) {
                                for (String value : attribute.getValueList()) {
                                    target.getCategory().add(value);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.ACTION) {
                                for (String value : attribute.getValueList()) {
                                    target.setAction(value);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.TYPE) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setType(value);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.SCHEME) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setScheme(value);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.SSP) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setSsp(value);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.HOST) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setHost(value);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.PORT) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setPort(value);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.PATH) {
                                for (String value : attribute.getValueList()) {
                                    if (dataObj == null) {
                                        dataObj = new Data();
                                    }
                                    dataObj.setPath(value);
                                }
                                continue;
                            }
                            if (attribute.getKind() == Ic3Data.AttributeKind.CLASS) {
                                for (String value : attribute.getValueList()) {
                                    if (targetRef == null) {
                                        targetRef = new Reference();
                                    }
                                    targetRef.setClassname(value.replace("/", "."));
                                }
                                continue;
                            }
                            if (attribute.getKind() != Ic3Data.AttributeKind.PACKAGE) continue;
                            for (String value : attribute.getValueList()) {
                                if (targetRef == null) {
                                    targetRef = new Reference();
                                }
                                if (targetRef.getClass() != null && !targetRef.getClassname().equals("")) continue;
                                targetRef.setClassname(value);
                            }
                        }
                        if (targetRef != null) {
                            target.setReference(targetRef);
                        }
                        if (dataObj != null) {
                            target.setData(dataObj);
                        }
                        intentObj.setTarget(target);
                        intentsink.setTarget(target);
                        answer.getIntents().getIntent().add(intentObj);
                        answer.getIntentsinks().getIntentsink().add(intentsink);
                    }
                }
            }
        }
        return answer;
    }
}

