/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.datastructure;

import de.foellix.aql.datastructure.IQuestionNode;
import de.foellix.aql.datastructure.PreviousQuestion;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.helper.Helper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuestionPart
implements IQuestionNode,
Serializable {
    private static final long serialVersionUID = -3835466478917897792L;
    private int mode = 0;
    private List<Reference> references = new ArrayList<Reference>();
    private final Map<Reference, List<String>> preprocessorMap = new HashMap<Reference, List<String>>();
    private final List<String> features = new ArrayList<String>();

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int level) {
        int i;
        StringBuilder sb = new StringBuilder();
        String indent = "";
        for (i = 0; i < level; ++i) {
            indent = indent + "\t";
        }
        sb.append(indent + "QUESTION (\n" + indent + "\tMode: " + Helper.modeToString(this.mode) + "\n" + indent + "\tReferences:\n");
        for (i = 0; i < this.references.size(); ++i) {
            sb.append(indent + "\t" + i + ".\n" + indent + "\t" + Helper.toString(this.references.get(i), level + 1));
            if (this.preprocessorMap.get(this.references.get(i)) != null) {
                boolean first = true;
                for (String keyword : this.preprocessorMap.get(this.references.get(i))) {
                    if (first) {
                        sb.append(" <- " + keyword);
                        first = false;
                        continue;
                    }
                    sb.append(", " + keyword);
                }
            }
            sb.append("\n");
        }
        sb.append(indent + ")");
        if (!this.features.isEmpty()) {
            sb.append(" FEATURES: ");
            for (int o = 0; o < this.features.size(); ++o) {
                sb.append(this.features.get(o));
                if (o == this.features.size() - 1) continue;
                sb.append(", ");
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public String toRAW() {
        StringBuilder sb = new StringBuilder();
        for (Reference reference : this.references) {
            sb.append(Helper.toRAW(reference));
        }
        return sb.toString();
    }

    @Override
    public List<IQuestionNode> getChildren() {
        return null;
    }

    @Override
    public List<QuestionPart> getAllQuestionParts() {
        ArrayList<QuestionPart> temp = new ArrayList<QuestionPart>();
        temp.add(this);
        return temp;
    }

    @Override
    public List<PreviousQuestion> getAllPreviousQuestions() {
        return null;
    }

    public void addReference(Reference reference) {
        this.references.add(reference);
    }

    public void addPreprocessor(Reference reference, List<String> preprocessors) {
        this.preprocessorMap.put(reference, preprocessors);
    }

    public void removePreprocessor(Reference reference, String preprocessorKeyword) {
        if (this.preprocessorMap.get(reference).size() == 1 || preprocessorKeyword == null) {
            this.preprocessorMap.remove(reference);
        } else {
            preprocessorKeyword = preprocessorKeyword.replaceAll("'", "");
            String remove = null;
            for (String keyword : this.preprocessorMap.get(reference)) {
                if (!keyword.replaceAll("'", "").equals(preprocessorKeyword)) continue;
                remove = keyword;
                break;
            }
            if (remove != null) {
                this.preprocessorMap.get(reference).remove(remove);
            }
        }
    }

    public List<String> getPreprocessor(Reference reference) {
        return this.preprocessorMap.get(reference);
    }

    public int getMode() {
        return this.mode;
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setReferences(List<Reference> references) {
        this.references = references;
    }

    public List<String> getFeatures() {
        return this.features;
    }
}

