/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.datastructure.handler;

import de.foellix.aql.datastructure.PreviousQuestion;
import de.foellix.aql.datastructure.Question;
import de.foellix.aql.datastructure.QuestionFilter;
import de.foellix.aql.datastructure.QuestionPart;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.Statement;
import de.foellix.aql.helper.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class QuestionHandler {
    private Stack<Question> stack;
    private List<String> features;
    private QuestionPart currentQuestion;
    private Reference currentReference;
    private List<String> currentPreprocessors;
    private String currentName = null;
    private String currentValue = null;
    private int currentSOI = -1;

    public void startQuery() {
        this.stack = new Stack();
        this.stack.push(new Question("COLLECTION"));
    }

    public void startOperator(String operator) {
        Question temp = operator.equals("FILTER") ? new QuestionFilter(operator) : new Question(operator);
        this.stack.peek().addChild(temp);
        this.stack.push(temp);
    }

    public void setFilterNameValuePair(String name, String value) {
        this.currentName = name;
        this.currentValue = value;
    }

    public void setFilterSOI(String soi) {
        this.currentSOI = this.soiToType(soi);
    }

    public void endOperator() {
        if (this.stack.peek() instanceof QuestionFilter) {
            ((QuestionFilter)this.stack.peek()).setName(this.currentName);
            ((QuestionFilter)this.stack.peek()).setValue(this.currentValue);
            ((QuestionFilter)this.stack.peek()).setSoi(this.currentSOI);
            this.currentName = null;
            this.currentValue = null;
            this.currentSOI = -1;
        }
        this.stack.pop();
    }

    public void startQuestion() {
        this.currentQuestion = new QuestionPart();
        this.currentPreprocessors = new ArrayList<String>();
    }

    public void endQuestion() {
        this.stack.peek().addChild(this.currentQuestion);
    }

    public void setMode(String soi) {
        int type = this.soiToType(soi);
        this.currentQuestion.setMode(type);
    }

    public void addReference() {
        this.currentQuestion.addPreprocessor(this.currentReference, this.currentPreprocessors);
        this.currentPreprocessors = new ArrayList<String>();
        this.currentQuestion.addReference(this.currentReference);
        this.currentReference = null;
    }

    public void setReferenceType(String type) {
        this.currentReference.setType(type);
    }

    public void setStatement(String value) {
        value = this.init(value);
        Statement statement = Helper.fromStatementString(value);
        this.currentReference.setStatement(statement);
    }

    public void setMethod(String value) {
        value = this.init(value);
        this.currentReference.setMethod(value);
    }

    public void setClass(String value) {
        value = this.init(value);
        this.currentReference.setClassname(value);
    }

    public void setApp(String value) {
        if (value.equals("''") || value.equals("'/'") || value.equals("''") || value.equals("'*'")) {
            value = "'.'";
        } else if (value.endsWith("*'")) {
            value = value.substring(0, value.length() - 2) + "'";
        }
        value = this.init(value);
        this.currentReference.setApp(Helper.createApp(value));
    }

    public void addPreprocessor(String preprocessor) {
        this.currentPreprocessors.add(preprocessor);
    }

    private String init(String value) {
        if (this.currentReference == null) {
            this.currentReference = new Reference();
        }
        return value.substring(1, value.length() - 1);
    }

    public Question getCollection() {
        return (Question)this.stack.firstElement();
    }

    public void addAnswer(String file) {
        PreviousQuestion pq = new PreviousQuestion(file);
        this.stack.peek().addChild(pq);
    }

    private int soiToType(String soi) {
        switch (soi) {
            case "Flows": {
                return 0;
            }
            case "IntentFilters": {
                return 3;
            }
            case "Intents": {
                return 2;
            }
            case "IntentSinks": {
                return 5;
            }
            case "IntentSources": {
                return 4;
            }
            case "Permissions": {
                return 1;
            }
        }
        return -1;
    }

    public void addFeature(String feature) {
        this.currentQuestion.getFeatures().add(feature.substring(1, feature.length() - 1));
    }
}

