/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.Data;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Hash;
import de.foellix.aql.datastructure.Hashes;
import de.foellix.aql.datastructure.Intent;
import de.foellix.aql.datastructure.Intentfilter;
import de.foellix.aql.datastructure.Intentsink;
import de.foellix.aql.datastructure.Intentsource;
import de.foellix.aql.datastructure.Permission;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.Statement;
import de.foellix.aql.datastructure.Target;
import de.foellix.aql.helper.HashHelper;
import de.foellix.aql.helper.Helper;
import java.io.File;
import java.util.List;

public class EqualsHelper {
    public static boolean equals(Reference reference1, Reference reference2) {
        return EqualsHelper.equals(reference1, reference2, false);
    }

    public static boolean equals(Reference reference1, Reference reference2, boolean nullAllowedOnLeftHandSide) {
        return EqualsHelper.equals(reference1, reference2, nullAllowedOnLeftHandSide, false);
    }

    public static boolean equals(Reference reference1, Reference reference2, boolean nullAllowedOnLeftHandSide, boolean precisely) {
        if (precisely) {
            if (reference1 == null && reference2 == null) {
                return true;
            }
            if (reference1 == null || reference2 == null) {
                return false;
            }
            return EqualsHelper.equals(reference1.getApp(), reference2.getApp()) && (reference1.getClassname() == null && reference2.getClassname() == null || reference1.getClassname() != null && reference2.getClassname() != null && reference1.getClassname().equals(reference2.getClassname())) && (reference1.getMethod() == null && reference2.getMethod() == null || reference1.getMethod() != null && reference2.getMethod() != null && reference1.getMethod().equals(reference2.getMethod())) && EqualsHelper.equals(reference1.getStatement(), reference2.getStatement());
        }
        if (EqualsHelper.equals(reference1.getApp(), reference2.getApp()) && (nullAllowedOnLeftHandSide && reference1.getClassname() == null || reference1.getClassname().equals(reference2.getClassname())) && (nullAllowedOnLeftHandSide && reference1.getMethod() == null || reference1.getMethod().equals(reference2.getMethod()))) {
            if (nullAllowedOnLeftHandSide && reference1.getStatement() == null || EqualsHelper.equals(reference1.getStatement(), reference2.getStatement())) {
                return true;
            }
            if (reference1.getStatement().getStatementgeneric() == null || reference1.getStatement().getStatementgeneric().equals("") || reference2.getStatement().getStatementgeneric() == null || reference2.getStatement().getStatementgeneric().equals("")) {
                if (Helper.cut(reference1.getStatement().getStatementfull(), "<", ">").equals(Helper.cut(reference2.getStatement().getStatementfull(), "<", ">"))) {
                    Log.warning("Statements are equal only on generic level:\n" + reference1.getStatement().getStatementfull() + "\n" + reference2.getStatement().getStatementfull());
                    return true;
                }
            } else if (reference1.getStatement().getStatementgeneric().equals(reference2.getStatement().getStatementgeneric())) {
                Log.warning("Statements are equal only on generic level:\n" + reference1.getStatement().getStatementfull() + "\n" + reference2.getStatement().getStatementfull());
                return true;
            }
        }
        return false;
    }

    public static boolean equals(App app1, App app2) {
        return EqualsHelper.equals(app1, app2, false);
    }

    public static boolean equals(App app1, App app2, boolean generateHashIfNotAvailable) {
        boolean check = EqualsHelper.equals(app1.getHashes(), app2.getHashes());
        if (generateHashIfNotAvailable && !check && app1.getFile() != null && app2.getFile() != null && !app1.getFile().equals("") && !app2.getFile().equals("")) {
            String hash2;
            String hash1;
            File file1 = new File(app1.getFile());
            File file2 = new File(app2.getFile());
            if (file1.exists() && file2.exists() && (hash1 = HashHelper.sha256Hash(file1)).equals(hash2 = HashHelper.sha256Hash(file2))) {
                return true;
            }
        }
        return check;
    }

    public static boolean equals(Hashes hashes1, Hashes hashes2) {
        for (Hash ref1Hash : hashes1.getHash()) {
            for (Hash ref2Hash : hashes2.getHash()) {
                if (ref1Hash.getValue() == null || ref2Hash.getValue() == null || ref1Hash.getType() == null || ref2Hash.getType() == null || !ref1Hash.getType().equals(ref2Hash.getType()) || !ref1Hash.getValue().equals(ref2Hash.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equals(Statement statement1, Statement statement2) {
        if (statement1 == null && statement2 != null || statement1 != null && statement2 == null) {
            String warning = "Could not compare statements. One statement is null the other one is:\n";
            warning = statement1 == null ? warning + statement2.getStatementfull() : warning + statement1.getStatementfull();
            Log.warning(warning);
            return true;
        }
        if (statement1 == null && statement2 == null) {
            return true;
        }
        String ref1String = statement1.getStatementfull().replaceAll("\\$", "");
        String ref2String = statement2.getStatementfull().replaceAll("\\$", "");
        return ref1String.equals(ref2String);
    }

    public static boolean equals(Permission permission1, Permission permission2) {
        return permission1.getName().equals(permission2.getName()) && EqualsHelper.equals(permission1.getReference(), permission2.getReference());
    }

    public static boolean equals(Intent intent1, Intent intent2) {
        return EqualsHelper.equals(intent1.getReference(), intent2.getReference()) && EqualsHelper.equals(intent1.getTarget(), intent2.getTarget());
    }

    public static boolean equals(Intentfilter filter1, Intentfilter filter2) {
        Target temp1 = new Target();
        temp1.setAction(filter1.getAction());
        temp1.getCategory().addAll(filter1.getCategory());
        temp1.setData(filter1.getData());
        Target temp2 = new Target();
        temp2.setAction(filter2.getAction());
        temp2.getCategory().addAll(filter2.getCategory());
        temp2.setData(filter2.getData());
        return EqualsHelper.equals(filter1.getReference(), filter2.getReference(), true) && EqualsHelper.equals(temp1, temp2);
    }

    public static boolean equals(Intentsink sink1, Intentsink sink2) {
        return EqualsHelper.equals(sink1.getReference(), sink2.getReference()) && EqualsHelper.equals(sink1.getTarget(), sink2.getTarget());
    }

    public static boolean equals(Intentsource source1, Intentsource source2) {
        return EqualsHelper.equals(source1.getReference(), source2.getReference()) && EqualsHelper.equals(source1.getTarget(), source2.getTarget());
    }

    public static boolean equals(Flow path1, Flow path2) {
        Reference path1From = null;
        Reference path1To = null;
        Reference path2From = null;
        Reference path2To = null;
        for (Reference ref : path1.getReference()) {
            if (ref.getType().equals("from")) {
                path1From = ref;
                continue;
            }
            if (!ref.getType().equals("to")) continue;
            path1To = ref;
        }
        for (Reference ref : path2.getReference()) {
            if (ref.getType().equals("from")) {
                path2From = ref;
                continue;
            }
            if (!ref.getType().equals("to")) continue;
            path2To = ref;
        }
        return EqualsHelper.equals(path1From, path2From) && EqualsHelper.equals(path1To, path2To);
    }

    public static boolean equalsConnect(Intentsource source, Intentsink sink) {
        return EqualsHelper.equals(sink.getTarget(), source.getTarget());
    }

    public static boolean equalsConnect(Intentsink sink, Intentsource source) {
        return EqualsHelper.equals(sink.getTarget(), source.getTarget());
    }

    public static boolean equals(Target target1, Target target2) {
        return EqualsHelper.equals(target1, target2, false);
    }

    public static boolean equals(Target target1, Target target2, boolean precisely) {
        if (precisely) {
            if (target1 == null && target2 == null) {
                return true;
            }
            if (target1 == null || target2 == null) {
                return false;
            }
            return (target1.getAction() == null && target2.getAction() == null || target1.getAction() != null && target2.getAction() != null && target1.getAction().equals(target2.getAction())) && (target1.getCategory() == null && target2.getCategory() == null || target1.getCategory() != null && target2.getCategory() != null && EqualsHelper.equals(target1.getCategory(), target2.getCategory())) && (target1.getData() == null && target2.getData() == null || target1.getData() != null && target2.getData() != null && EqualsHelper.equals(target1.getData(), target2.getData())) && (target1.getReference() == null && target2.getReference() == null || target1.getReference() != null && target2.getReference() != null && EqualsHelper.equals(target1.getReference(), target2.getReference(), false, true));
        }
        if (target1 != null && target2 != null) {
            try {
                if ((target1.getAction() == null && target2.getAction() == null || target1.getAction().equals(target2.getAction())) && target1.getCategory() != null && target2.getCategory() != null) {
                    for (String category1 : target1.getCategory()) {
                        for (String category2 : target2.getCategory()) {
                            if (!category1.equals(category2)) continue;
                            return true;
                        }
                    }
                }
            }
            catch (NullPointerException e1) {
                try {
                    if (target1.getAction() != null && target2.getAction() != null && target1.getAction().equals(target2.getAction()) && (target1.getCategory() == null && target2.getCategory() != null || target1.getCategory() != null && target2.getCategory() == null)) {
                        Log.warning("Action (" + target1.getAction() + ") matches, but category (" + target1.getCategory() + ", " + target2.getCategory() + ") does not.");
                        return true;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (target1.getReference() != null && target2.getReference() != null && target1.getReference().getClassname() != null && target2.getReference().getClassname() != null && target1.getReference().getClassname().equals(target2.getReference().getClassname())) {
                return true;
            }
        }
        return false;
    }

    public static boolean equals(List<String> category1, List<String> category2) {
        boolean catEquals = true;
        for (String cat1 : category1) {
            boolean found = false;
            for (String cat2 : category2) {
                if (!cat1.equals(cat2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            catEquals = false;
            break;
        }
        return catEquals;
    }

    public static boolean equals(Data data1, Data data2) {
        return data1.getHost().equals(data2.getHost()) && data1.getPath().equals(data2.getPath()) && data1.getPort().equals(data2.getPort()) && data1.getScheme().equals(data2.getScheme()) && data1.getSsp().equals(data2.getSsp()) && data1.getType().equals(data2.getType());
    }
}

