/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import de.foellix.aql.config.Tool;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.Hash;
import de.foellix.aql.datastructure.Hashes;
import de.foellix.aql.datastructure.IQuestionNode;
import de.foellix.aql.datastructure.QuestionPart;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.helper.Helper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashHelper {
    public static String createHash(Tool tool, IQuestionNode question) {
        String hash = Helper.toRAW(tool) + question.toRAW();
        return HashHelper.sha256Hash(hash);
    }

    public static String createHash(Tool tool, App app) {
        String hash = Helper.toRAW(tool) + Helper.toRAW(app);
        return HashHelper.sha256Hash(hash);
    }

    public static String createGenericHash(IQuestionNode question) {
        IQuestionNode copy = Helper.copy(question);
        for (QuestionPart part : copy.getAllQuestionParts()) {
            for (Reference ref : part.getReferences()) {
                ref.setClassname(null);
                ref.setMethod(null);
                ref.setStatement(null);
            }
        }
        String hash = copy.toRAW();
        return HashHelper.sha256Hash(hash);
    }

    public static String md5Hash(File file) {
        return HashHelper.hash(file, "MD5");
    }

    public static String md5Hash(String string) {
        return HashHelper.hash(string, "MD5");
    }

    public static String sha1Hash(File file) {
        return HashHelper.hash(file, "SHA-1");
    }

    public static String sha1Hash(String string) {
        return HashHelper.hash(string, "SHA-1");
    }

    public static String sha256Hash(File file) {
        return HashHelper.hash(file, "SHA-256");
    }

    public static String sha256Hash(String string) {
        return HashHelper.hash(string, "SHA-256");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String hash(File file, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            FileInputStream is = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            try {
                int read;
                while ((read = ((InputStream)is).read(buffer)) > 0) {
                    digest.update(buffer, 0, read);
                }
                byte[] hash = digest.digest();
                String string = HashHelper.makeOutput(hash);
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to process file.", e);
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e2) {
                    return null;
                }
            }
        }
        catch (FileNotFoundException | NoSuchAlgorithmException e3) {
            return null;
        }
    }

    private static String hash(String string, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] hash = digest.digest(string.getBytes());
            return HashHelper.makeOutput(hash);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private static String makeOutput(byte[] byteStr) {
        BigInteger bigInt = new BigInteger(1, byteStr);
        String output = bigInt.toString(16);
        output = String.format("%32s", output).replace(' ', '0');
        return output;
    }

    public static String getHash(Hashes hashes, String type) {
        for (Hash hash : hashes.getHash()) {
            if (!hash.getType().equals(type)) continue;
            return hash.getValue();
        }
        return null;
    }
}

