/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import de.foellix.aql.Log;
import de.foellix.aql.config.Config;
import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.config.Priority;
import de.foellix.aql.config.Tool;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.Attribute;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Flows;
import de.foellix.aql.datastructure.Hash;
import de.foellix.aql.datastructure.Hashes;
import de.foellix.aql.datastructure.IQuestionNode;
import de.foellix.aql.datastructure.Intent;
import de.foellix.aql.datastructure.Intentfilter;
import de.foellix.aql.datastructure.Intentsink;
import de.foellix.aql.datastructure.Intentsinks;
import de.foellix.aql.datastructure.Intentsource;
import de.foellix.aql.datastructure.Intentsources;
import de.foellix.aql.datastructure.Parameter;
import de.foellix.aql.datastructure.Parameters;
import de.foellix.aql.datastructure.Permission;
import de.foellix.aql.datastructure.Permissions;
import de.foellix.aql.datastructure.Question;
import de.foellix.aql.datastructure.QuestionFilter;
import de.foellix.aql.datastructure.QuestionPart;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.Statement;
import de.foellix.aql.datastructure.Target;
import de.foellix.aql.helper.EqualsHelper;
import de.foellix.aql.helper.HashHelper;
import de.foellix.aql.helper.ManifestHelper;
import de.foellix.aql.helper.ManifestInfo;
import de.foellix.aql.system.DefaultOperator;
import de.foellix.aql.system.task.OperatorTaskInfo;
import de.foellix.aql.system.task.TaskInfo;
import de.foellix.aql.system.task.ToolTaskInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class Helper {
    public static final int OCCURENCE_LAST = -1;

    public static String cut(String input, String from, String to) {
        return Helper.cut(input, from, to, 1);
    }

    public static String cutFromFirstToLast(String input, String fromFirst, String toLast) {
        try {
            return input.substring(input.indexOf(fromFirst) + fromFirst.length(), input.lastIndexOf(toLast));
        }
        catch (StringIndexOutOfBoundsException e) {
            Log.msg("Non valid input: " + input, 6);
            return input;
        }
    }

    public static String cut(String input, String from) {
        return Helper.cut(input, from, 1);
    }

    public static String cut(String input, String from, String to, int occurence) {
        try {
            int pos1 = 0;
            int pos2 = 0;
            if (occurence == -1) {
                occurence = (input.length() - input.replace(from, "").length()) / from.length();
            }
            for (int i = 0; i < occurence; ++i) {
                if (from != null) {
                    pos1 = input.indexOf(from, pos1) + from.length();
                    pos2 = input.indexOf(to, pos1);
                    continue;
                }
                pos2 = input.indexOf(to, pos2);
            }
            return input.substring(pos1, pos2);
        }
        catch (StringIndexOutOfBoundsException e) {
            Log.msg("Non valid input: " + input, 6);
            return input;
        }
    }

    public static String cut(String input, String from, int occurence) {
        try {
            int pos1 = 0;
            if (occurence == -1) {
                occurence = (input.length() - input.replace(from, "").length()) / from.length();
            }
            for (int i = 0; i < occurence; ++i) {
                pos1 = input.indexOf(from, pos1) + from.length();
            }
            return input.substring(pos1);
        }
        catch (StringIndexOutOfBoundsException e) {
            Log.msg("Non valid input: " + input, 6);
            return input;
        }
    }

    public static String cutFromStart(String input, String to) {
        return Helper.cutFromStart(input, to, 1);
    }

    public static String cutFromStart(String input, String to, int occurence) {
        return Helper.cut(input, null, to, occurence);
    }

    public static String modeToString(int mode) {
        switch (mode) {
            case 0: {
                return "Flows";
            }
            case 3: {
                return "IntentFilters";
            }
            case 2: {
                return "Intents";
            }
            case 5: {
                return "IntentSinks";
            }
            case 4: {
                return "IntentSources";
            }
            case 1: {
                return "Permissions";
            }
        }
        return "Unknown";
    }

    public static IQuestionNode copy(IQuestionNode question) {
        if (question instanceof Question || question instanceof QuestionFilter) {
            return Helper.copy((Question)question);
        }
        return Helper.copy((QuestionPart)question);
    }

    public static Question copy(Question question) {
        Question newQuestion;
        if (question instanceof QuestionFilter) {
            newQuestion = new QuestionFilter(question.getOperator());
            ((QuestionFilter)newQuestion).setName(((QuestionFilter)question).getName());
            ((QuestionFilter)newQuestion).setValue(((QuestionFilter)question).getValue());
            ((QuestionFilter)newQuestion).setSoi(((QuestionFilter)question).getSoi());
        } else {
            newQuestion = new Question(question.getOperator());
        }
        for (IQuestionNode child : question.getChildren()) {
            newQuestion.getChildren().add(Helper.copy(child));
        }
        return newQuestion;
    }

    public static QuestionPart copy(QuestionPart questionPart) {
        QuestionPart newQuestionPart = new QuestionPart();
        newQuestionPart.setMode(questionPart.getMode());
        for (Reference ref : questionPart.getReferences()) {
            newQuestionPart.addReference(Helper.copy(ref));
        }
        return newQuestionPart;
    }

    public static Reference copy(Reference reference) {
        if (reference == null) {
            return null;
        }
        Reference newReference = new Reference();
        if (reference.getApp() != null) {
            newReference.setApp(reference.getApp());
        }
        if (reference.getClassname() != null) {
            newReference.setClassname(reference.getClassname());
        }
        if (reference.getMethod() != null) {
            newReference.setMethod(reference.getMethod());
        }
        if (reference.getStatement() != null) {
            newReference.setStatement(reference.getStatement());
        }
        return newReference;
    }

    public static Statement fromStatementString(String statement) {
        Statement newstatement = new Statement();
        newstatement.setStatementfull(statement);
        newstatement.setStatementgeneric(Helper.cutFromFirstToLast(statement, "<", ">"));
        String classes = Helper.cut(statement, "(", ")", 1);
        if (!classes.equals("")) {
            String values = Helper.cut(statement, "(", ")", 2);
            newstatement.setParameters(new Parameters());
            String[] parameterClasses = classes.split(",");
            String[] parameterValues = values.split(", ");
            for (int i = 0; i < parameterClasses.length && i < parameterValues.length; ++i) {
                Parameter parameter = new Parameter();
                parameter.setType(parameterClasses[i]);
                parameter.setValue(parameterValues[i]);
                newstatement.getParameters().getParameter().add(parameter);
            }
        }
        return newstatement;
    }

    public static String toString(Answer answer) {
        StringBuilder sb = new StringBuilder();
        if (answer.getPermissions() != null) {
            sb.append("*** Permissions ***\n" + Helper.toString(answer.getPermissions()) + "\n");
        }
        if (answer.getFlows() != null) {
            sb.append("*** Flows ***\n" + Helper.toString(answer.getFlows()) + "\n");
        }
        if (answer.getIntentsources() != null) {
            sb.append("*** IntentSources ***\n" + Helper.toString(answer.getIntentsources()) + "\n");
        }
        if (answer.getIntentsinks() != null) {
            sb.append("*** IntentSinks ***\n" + Helper.toString(answer.getIntentsinks()) + "\n");
        }
        return sb.toString();
    }

    public static String toString(Reference reference) {
        return Helper.toString(reference, 0);
    }

    public static String toString(Reference reference, int level) {
        StringBuilder sb = new StringBuilder();
        String indent = "";
        for (int i = 0; i < level; ++i) {
            indent = indent + "\t";
        }
        if (reference != null) {
            if (reference.getStatement() != null && reference.getStatement().getStatementfull() != null) {
                sb.append(reference.getStatement().getStatementfull() + "\n" + indent + "-> ");
            }
            if (reference.getMethod() != null) {
                sb.append(reference.getMethod() + "\n" + indent + "-> ");
            }
            if (reference.getClassname() != null) {
                sb.append(reference.getClassname() + "\n" + indent + "-> ");
            }
            if (reference.getApp() != null && reference.getApp().getFile() != null) {
                sb.append(reference.getApp().getFile());
            } else {
                sb.append("No .apk defined (Not App specific)");
            }
        } else {
            sb.append("No Reference");
        }
        return sb.toString();
    }

    public static Object toRAW(Reference reference) {
        StringBuilder sb = new StringBuilder();
        if (reference.getStatement() != null) {
            sb.append(reference.getStatement().getStatementfull());
        }
        if (reference.getMethod() != null) {
            sb.append(reference.getMethod());
        }
        if (reference.getClassname() != null) {
            sb.append(reference.getClassname());
        }
        if (reference.getApp() != null) {
            sb.append(Helper.toRAW(reference.getApp()));
        }
        return sb.toString();
    }

    public static Object toRAW(App app) {
        StringBuilder sb = new StringBuilder();
        for (Hash hash : app.getHashes().getHash()) {
            sb.append(hash.getType() + ": " + hash.getValue());
        }
        return sb.toString();
    }

    public static String toRAW(Tool tool) {
        return tool.getName() + "-" + tool.getVersion();
    }

    public static String toString(Permissions permissions) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < permissions.getPermission().size(); ++i) {
            sb.append("#" + (i + 1) + ":\n" + Helper.toString(permissions.getPermission().get(i)));
            if (i >= permissions.getPermission().size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Permission permission) {
        return permission.getName() + "\n-> " + Helper.toString(permission.getReference());
    }

    public static String toString(Flows flows) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < flows.getFlow().size(); ++i) {
            sb.append("#" + (i + 1) + ":\n");
            if (flows.getFlow().get(i).getAttributes() != null) {
                for (Attribute attr : flows.getFlow().get(i).getAttributes().getAttribute()) {
                    sb.append("(" + attr.getName() + " = " + attr.getValue() + ")\n");
                }
            }
            for (int j = 0; j < flows.getFlow().get(i).getReference().size(); ++j) {
                Reference reference = flows.getFlow().get(i).getReference().get(j);
                if (reference.getType().equals("from")) {
                    sb.append("From:\n" + Helper.toString(reference));
                } else if (reference.getType().equals("to")) {
                    sb.append("To:\n" + Helper.toString(reference));
                }
                if (j == flows.getFlow().get(i).getReference().size() - 1) continue;
                sb.append("\n");
            }
            if (i == flows.getFlow().size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Flow flow) {
        return "From:\n" + Helper.toString(Helper.getFrom(flow.getReference())) + "\nTo:\n" + Helper.toString(Helper.getTo(flow.getReference()));
    }

    public static String toString(Intentsources intentsources) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < intentsources.getIntentsource().size(); ++i) {
            sb.append("#" + (i + 1) + ":\n");
            sb.append(Helper.toString(intentsources.getIntentsource().get(i)));
            if (i >= intentsources.getIntentsource().size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Intentsource intentsource) {
        StringBuilder sb = new StringBuilder();
        sb.append(Helper.toString(intentsource.getTarget()));
        sb.append("Reference:\n" + Helper.toString(intentsource.getReference()));
        return sb.toString();
    }

    public static String toString(Intentsinks intentsinks) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < intentsinks.getIntentsink().size(); ++i) {
            sb.append("#" + (i + 1) + ":\n");
            sb.append(Helper.toString(intentsinks.getIntentsink().get(i)));
            if (i >= intentsinks.getIntentsink().size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Intentsink intentsink) {
        StringBuilder sb = new StringBuilder();
        sb.append(Helper.toString(intentsink.getTarget()));
        sb.append("Reference:\n" + Helper.toString(intentsink.getReference()));
        return sb.toString();
    }

    public static String toString(Target target) {
        StringBuilder sb = new StringBuilder();
        if (target.getAction() != null) {
            sb.append("Action: " + target.getAction() + "\n");
        }
        if (target.getCategory() != null) {
            sb.append("Category: " + target.getCategory() + "\n");
        }
        if (target.getData() != null) {
            sb.append("Data: is set\n");
        }
        if (target.getReference() != null) {
            sb.append("Class: " + target.getReference().getClassname() + "\n");
        }
        return sb.toString();
    }

    public static String toString(List<Tool> tools) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tools.size(); ++i) {
            sb.append("#" + (i + 1) + ":\n");
            sb.append(Helper.toString(tools.get(i)));
            if (i >= tools.size() - 1) continue;
            sb.append("\n\n");
        }
        return sb.toString();
    }

    public static String toString(Tool tool) {
        StringBuilder sb = new StringBuilder();
        sb.append("Name: " + tool.getName() + "\n");
        if (tool.getPriority().size() <= 1) {
            sb.append("Priority: " + tool.getPriority().get(0).getValue() + (tool.getPriority().get(0).getFeature() != null && !tool.getPriority().get(0).getFeature().equals("") ? " (" + tool.getPriority().get(0).getFeature() + ")" : "") + "\n");
        } else {
            sb.append("Priorities:\n");
            for (Priority priority : tool.getPriority()) {
                sb.append(priority.getValue() + (priority.getFeature() != null && !priority.getFeature().equals("") ? " (" + priority.getFeature() + ")" : "") + "\n");
            }
        }
        sb.append("Run: " + tool.getRun() + "\n");
        sb.append("Result: " + tool.getResult() + "\n");
        sb.append("Questions: " + tool.getQuestions() + "\n");
        sb.append("Instances: " + tool.getInstances() + "\n");
        sb.append("MemoryPerInstance: " + tool.getMemoryPerInstance());
        return sb.toString();
    }

    public static String replaceVariables(String str, OperatorTaskInfo taskinfo, List<File> tempAnswerFiles) {
        if ((str.contains("%ANSWERS%") || str.contains("%ANSWERSHASH%")) && tempAnswerFiles != null && !tempAnswerFiles.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < tempAnswerFiles.size(); ++i) {
                sb.append(tempAnswerFiles.get(i).getAbsolutePath().replaceAll("\\\\", "/") + (i != tempAnswerFiles.size() - 1 ? ", " : ""));
            }
            str = str.replaceAll("%ANSWERS%", sb.toString());
            str = str.replaceAll("%ANSWERSHASH%", HashHelper.sha256Hash(sb.toString()));
        } else {
            str = str.replaceAll("%ANSWERS%", "NOT_AVAILABLE");
            str = str.replaceAll("%ANSWERSHASH%", "NOT_AVAILABLE");
        }
        str = str.replaceAll("%ANDROID_PLATFORMS%", ConfigHandler.getInstance().getConfig().getAndroidPlatforms());
        str = Helper.replaceVariables(str, taskinfo);
        return str;
    }

    public static String replaceVariables(String str, TaskInfo taskinfo) {
        str = str.replaceAll("%MEMORY%", Integer.toString(taskinfo.getTool().getMemoryPerInstance()));
        str = str.replaceAll("%PID%", Integer.toString(taskinfo.getPID()));
        return str;
    }

    public static String replaceVariables(String str, TaskInfo taskinfo, App app) {
        Config cfg = ConfigHandler.getInstance().getConfig();
        File apkFile = new File(app.getFile());
        if (apkFile.exists()) {
            ManifestInfo manifestInfo = ManifestHelper.getInstance().getManifest(apkFile);
            return Helper.replaceVariables(str, taskinfo, cfg, apkFile, manifestInfo);
        }
        return Helper.replaceVariables(str, taskinfo, cfg, app.getFile());
    }

    public static String replaceVariables(String str, TaskInfo taskinfo, QuestionPart question) {
        Config cfg = ConfigHandler.getInstance().getConfig();
        if (question.getReferences().size() == 2) {
            return Helper.replaceVariables(str, taskinfo, cfg, question.getReferences().get(0).getApp().getFile() + " " + question.getReferences().get(1).getApp().getFile());
        }
        File apkFile = new File(question.getReferences().get(0).getApp().getFile());
        ManifestInfo manifestInfo = ManifestHelper.getInstance().getManifest(apkFile);
        return Helper.replaceVariables(str, taskinfo, cfg, apkFile, manifestInfo);
    }

    private static String replaceVariables(String str, TaskInfo taskinfo, Config cfg, File apkFile, ManifestInfo manifestInfo) {
        str = str.replaceAll("%APP_APK_FILENAME%", apkFile.getName().substring(0, apkFile.getName().length() - 4));
        str = str.replaceAll("%APP_APK%", apkFile.getAbsolutePath().replaceAll("\\\\", "/"));
        str = str.replaceAll("%APP_NAME%", manifestInfo.getAppName());
        str = str.replaceAll("%APP_PACKAGE%", manifestInfo.getPkgName());
        str = str.replaceAll("%ANDROID_PLATFORMS%", cfg.getAndroidPlatforms());
        str = Helper.replaceVariables(str, taskinfo);
        return str;
    }

    private static String replaceVariables(String str, TaskInfo taskinfo, Config cfg, String name) {
        String full = "";
        for (String onePart : name.split(" ")) {
            if (!(onePart = onePart.replaceAll("\\\\", "/")).contains("/")) continue;
            if (!full.equals("")) {
                full = full + " ";
            }
            full = full + Helper.cut(onePart, "/", -1);
        }
        String editedName = full.replaceAll(" ", "_").replaceAll(".apk", "");
        str = str.replaceAll("%APP_APK_FILENAME%", editedName);
        String files = "";
        for (String oneFile : name.split(" ")) {
            File apkFile = new File(oneFile);
            if (!files.equals("")) {
                files = files + " ";
            }
            files = files + apkFile.getAbsolutePath().replaceAll("\\\\", "/");
        }
        str = str.replaceAll("%APP_APK%", files);
        str = str.replaceAll("%APP_NAME%", editedName + "_name");
        str = str.replaceAll("%APP_PACKAGE%", editedName + "_pkg");
        str = str.replaceAll("%ANDROID_PLATFORMS%", cfg.getAndroidPlatforms());
        str = Helper.replaceVariables(str, taskinfo);
        return str;
    }

    public static String replaceVariables(String str, ToolTaskInfo taskinfo, File resultFile) {
        str = Helper.replaceVariables(str, (TaskInfo)taskinfo, taskinfo.getQuestion());
        return str.replaceAll("%RESULT_FILE%", resultFile.getAbsolutePath().replaceAll("\\\\", "/"));
    }

    public static boolean replaceQuestionPart(IQuestionNode question, QuestionPart needle, IQuestionNode replacement) {
        for (int i = 0; i < question.getChildren().size(); ++i) {
            if (question.getChildren().get(i) instanceof Question) {
                if (!Helper.replaceQuestionPart(question.getChildren().get(i), needle, replacement)) continue;
                return true;
            }
            if (question.getChildren().get(i) != needle) continue;
            question.getChildren().add(i, replacement);
            question.getChildren().remove(needle);
            return true;
        }
        return false;
    }

    public static boolean replaceAllQuestionPart(IQuestionNode question, QuestionPart needle, IQuestionNode replacement) {
        boolean goOn = true;
        while (goOn) {
            goOn = Helper.replaceQuestionPart(question, needle, replacement);
        }
        return true;
    }

    public static String getDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd_MM_yyyy-HH_mm");
        Date date = new Date();
        return dateFormat.format(date);
    }

    public static App createApp(File file) {
        return Helper.createApp(file.toString());
    }

    public static App createApp(String value) {
        App app = new App();
        app.setFile(value);
        Hashes hashes = new Hashes();
        File file = new File(value);
        Hash hashMD5 = new Hash();
        hashMD5.setType("MD5");
        Hash hashSHA1 = new Hash();
        hashSHA1.setType("SHA-1");
        Hash hashSHA256 = new Hash();
        hashSHA256.setType("SHA-256");
        if (file.exists()) {
            hashMD5.setValue(HashHelper.md5Hash(file));
            hashSHA1.setValue(HashHelper.sha1Hash(file));
            hashSHA256.setValue(HashHelper.sha256Hash(file));
        } else {
            hashMD5.setValue(HashHelper.md5Hash(value));
            hashSHA1.setValue(HashHelper.sha1Hash(value));
            hashSHA256.setValue(HashHelper.sha256Hash(value));
        }
        hashes.getHash().add(hashMD5);
        hashes.getHash().add(hashSHA1);
        hashes.getHash().add(hashSHA256);
        app.setHashes(hashes);
        return app;
    }

    public static File makeUnique(File file) {
        int i = 0;
        while (file.exists()) {
            file = new File(file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - (4 + String.valueOf(++i).length())) + i + ".xml");
        }
        return file;
    }

    public static File findFileWithAsterisk(File file) {
        if (!file.getAbsolutePath().contains("*")) {
            return file;
        }
        String[] needles = file.getName().split("\\*");
        file = new File(file.getAbsolutePath().replaceAll("\\*", "_"));
        boolean didNotExist = false;
        if (!file.exists()) {
            didNotExist = true;
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                Log.error("Analysis result could not be found or written: " + file.getAbsolutePath());
            }
        }
        for (File candidate : file.getParentFile().listFiles()) {
            if (didNotExist && candidate.equals(file)) continue;
            boolean valid = true;
            for (String needle : needles) {
                if (candidate.getName().contains(needle)) continue;
                valid = false;
            }
            if (!valid) continue;
            if (didNotExist) {
                file.delete();
            }
            return candidate;
        }
        if (didNotExist) {
            file.delete();
        }
        return file;
    }

    public static int getPid(Process p) {
        if (Platform.isWindows()) {
            try {
                Field f = p.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                WinNT.HANDLE handle = new WinNT.HANDLE();
                handle.setPointer(Pointer.createConstant(f.getLong(p)));
                int pid = Kernel32.INSTANCE.GetProcessId(handle);
                return pid;
            }
            catch (Exception ex) {
                Log.error("Could not identify process ID on this Windows operating system.");
            }
        } else if (Platform.isLinux()) {
            try {
                Field f = p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                int pid = (Integer)f.get(p);
                return pid;
            }
            catch (Exception ex) {
                Log.error("Could not identify process ID on this Linux operating system.");
            }
        } else {
            Log.error("Could not identify operating system.");
        }
        return -1;
    }

    public static Reference getFrom(List<Reference> references) {
        for (Reference ref : references) {
            if (!ref.getType().equals("from")) continue;
            return ref;
        }
        return null;
    }

    public static Reference getTo(List<Reference> references) {
        for (Reference ref : references) {
            if (!ref.getType().equals("to")) continue;
            return ref;
        }
        return null;
    }

    public static Answer removeRedundant(Answer answer) {
        Serializable obj2;
        int j;
        Serializable obj1;
        int i;
        if (answer.getPermissions() != null) {
            for (i = 0; i < answer.getPermissions().getPermission().size() - 1; ++i) {
                obj1 = answer.getPermissions().getPermission().get(i);
                for (j = i + 1; j < answer.getPermissions().getPermission().size(); ++j) {
                    obj2 = answer.getPermissions().getPermission().get(j);
                    if (!EqualsHelper.equals(obj1, obj2)) continue;
                    answer.getPermissions().getPermission().remove(j);
                }
            }
        }
        if (answer.getIntents() != null) {
            for (i = 0; i < answer.getIntents().getIntent().size() - 1; ++i) {
                obj1 = answer.getIntents().getIntent().get(i);
                for (j = i + 1; j < answer.getIntents().getIntent().size(); ++j) {
                    obj2 = answer.getIntents().getIntent().get(j);
                    if (!EqualsHelper.equals((Intent)obj1, (Intent)obj2)) continue;
                    answer.getIntents().getIntent().remove(j);
                }
            }
        }
        if (answer.getIntentfilters() != null) {
            for (i = 0; i < answer.getIntentfilters().getIntentfilter().size() - 1; ++i) {
                obj1 = answer.getIntentfilters().getIntentfilter().get(i);
                for (j = i + 1; j < answer.getIntentfilters().getIntentfilter().size(); ++j) {
                    obj2 = answer.getIntentfilters().getIntentfilter().get(j);
                    if (!EqualsHelper.equals((Intentfilter)obj1, (Intentfilter)obj2)) continue;
                    answer.getIntentfilters().getIntentfilter().remove(j);
                }
            }
        }
        if (answer.getIntentsinks() != null) {
            for (i = 0; i < answer.getIntentsinks().getIntentsink().size() - 1; ++i) {
                obj1 = answer.getIntentsinks().getIntentsink().get(i);
                for (j = i + 1; j < answer.getIntentsinks().getIntentsink().size(); ++j) {
                    obj2 = answer.getIntentsinks().getIntentsink().get(j);
                    if (!EqualsHelper.equals((Intentsink)obj1, (Intentsink)obj2)) continue;
                    answer.getIntentsinks().getIntentsink().remove(j);
                }
            }
        }
        if (answer.getIntentsources() != null) {
            for (i = 0; i < answer.getIntentsources().getIntentsource().size() - 1; ++i) {
                obj1 = answer.getIntentsources().getIntentsource().get(i);
                for (j = i + 1; j < answer.getIntentsources().getIntentsource().size(); ++j) {
                    obj2 = answer.getIntentsources().getIntentsource().get(j);
                    if (!EqualsHelper.equals((Intentsource)obj1, (Intentsource)obj2)) continue;
                    answer.getIntentsources().getIntentsource().remove(j);
                }
            }
        }
        if (answer.getFlows() != null) {
            for (i = 0; i < answer.getFlows().getFlow().size() - 1; ++i) {
                obj1 = answer.getFlows().getFlow().get(i);
                for (j = i + 1; j < answer.getFlows().getFlow().size(); ++j) {
                    obj2 = answer.getFlows().getFlow().get(j);
                    if (!EqualsHelper.equals((Flow)obj1, (Flow)obj2)) continue;
                    answer.getFlows().getFlow().remove(j);
                }
            }
        }
        return answer;
    }

    public static int getCardinality(Tool tool, String operator) {
        if (tool == null || operator == null) {
            return 2;
        }
        if (tool instanceof DefaultOperator) {
            if (operator.equals("FILTER")) {
                return 1;
            }
            return 2;
        }
        for (String splitStr : tool.getQuestions().replaceAll(" ", "").split(",")) {
            if (splitStr.equals(operator)) {
                return 0;
            }
            if (!splitStr.contains("(") || !splitStr.substring(0, splitStr.indexOf("(")).equals(operator)) continue;
            String cardinality = splitStr.substring(splitStr.indexOf("(") + 1, splitStr.indexOf(")"));
            if (cardinality.equals("*")) {
                return 0;
            }
            return Integer.valueOf(cardinality);
        }
        return -1;
    }

    public static void waitForResult(String msg, File result) throws FileNotFoundException, InterruptedException {
        for (int i = 0; i <= 10; ++i) {
            if (result.exists()) {
                Log.msg("Result available: " + result.getAbsolutePath(), 6);
                break;
            }
            Thread.sleep(1000L);
        }
        if (!result.exists()) {
            throw new FileNotFoundException(msg + "\n(" + result.getAbsolutePath() + ")");
        }
    }
}

