/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import de.foellix.aql.Log;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.System;
import de.foellix.aql.system.task.ExtraTask;
import de.foellix.aql.system.task.OperatorTask;
import de.foellix.aql.system.task.PreprocessorTask;
import de.foellix.aql.system.task.PreprocessorTaskInfo;
import de.foellix.aql.system.task.TaskAbortedBeforeException;
import de.foellix.aql.system.task.TaskInfo;
import de.foellix.aql.system.task.TaskMemory;
import de.foellix.aql.system.task.TaskStatus;
import de.foellix.aql.system.task.TaskTimer;
import de.foellix.aql.system.task.ToolTask;
import de.foellix.aql.system.task.ToolTaskInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Task
extends Thread {
    private final System parent;
    private final TaskInfo taskinfo;
    private long start;
    private long time;
    private final long timeout;
    private boolean done;
    private boolean destroyed;
    private boolean executed;
    private Process process;

    public Task(System parent, TaskInfo taskinfo, long timeout) {
        this.parent = parent;
        this.taskinfo = taskinfo;
        this.timeout = timeout;
        this.done = false;
        this.destroyed = false;
        this.executed = false;
    }

    @Override
    public void run() {
        try {
            if (TaskMemory.getInstance().contains(this)) {
                this.start = java.lang.System.currentTimeMillis() - this.timeout * 1000L;
                throw new TaskAbortedBeforeException("The associated task has been aborted before.");
            }
            if (this.timeout > 0L) {
                new TaskTimer(this, this.timeout).start();
            }
            this.start = java.lang.System.currentTimeMillis();
            if (this.taskinfo instanceof ToolTaskInfo) {
                new ToolTask(this).execute();
            } else if (this.taskinfo instanceof PreprocessorTaskInfo) {
                new PreprocessorTask(this).execute();
            } else {
                new OperatorTask(this).execute();
            }
        }
        catch (Exception err) {
            this.time = Math.max(1L, (java.lang.System.currentTimeMillis() - this.start) / 1000L);
            TaskMemory.getInstance().aborted(this);
            if (this.taskinfo instanceof ToolTaskInfo) {
                new ToolTask(this).abort(err);
            } else if (this.taskinfo instanceof PreprocessorTaskInfo) {
                new PreprocessorTask(this).abort(err);
            } else {
                new OperatorTask(this).abort(err);
            }
            this.parent.getScheduler().finishedTask(this, this.taskinfo, TaskStatus.STATUS_ABORT);
        }
        finally {
            this.done = true;
        }
    }

    @Override
    public void interrupt() {
        if (this.process != null) {
            this.destroyed = true;
            new ExtraTask(this.taskinfo, TaskStatus.STATUS_ABORT).runAndWait();
            if (this.process.isAlive()) {
                this.process.destroy();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Log.error("Someting went wrong while killing processes: " + e.getMessage());
                }
                if (this.process.isAlive()) {
                    this.process.destroyForcibly();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Log.error("Someting went wrong while killing processes: " + e.getMessage());
                    }
                }
            }
        }
        super.interrupt();
    }

    public void setupProcess(Process process, boolean ignore) throws IOException {
        this.process = process;
        this.taskinfo.setPID(Helper.getPid(process));
        if (ignore || Log.logIt(6)) {
            String line;
            BufferedReader input1 = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            while ((line = input1.readLine()) != null) {
                Log.msg("Process (output): " + line, 6);
            }
            input1.close();
            BufferedReader input2 = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
            while ((line = input2.readLine()) != null) {
                Log.msg("Process (error): " + line, 6);
            }
            input2.close();
        } else {
            this.process.getErrorStream().close();
            this.process.getOutputStream().close();
        }
    }

    public void successPart1(String msg) {
        this.time = Math.max(1L, (java.lang.System.currentTimeMillis() - this.start) / 1000L);
        msg = msg.replaceAll("%TIME%", String.valueOf(this.time));
        Log.msg(msg, 0);
        this.executed = true;
    }

    public void successPart2(boolean wait) throws InterruptedException {
        if (wait && this.taskinfo.getTool().getInstances() == 1) {
            Thread.sleep(1000L);
        }
        new ExtraTask(this.taskinfo, TaskStatus.STATUS_SUCCESS).runAndWait();
        this.getParent().getScheduler().finishedTask(this, this.taskinfo, TaskStatus.STATUS_SUCCESS);
    }

    public void failed(String msg) throws InterruptedException {
        if (this.destroyed) {
            throw new InterruptedException();
        }
        this.time = Math.max(1L, (java.lang.System.currentTimeMillis() - this.start) / 1000L);
        msg = msg.replaceAll("%TIME%", String.valueOf(this.time));
        Log.msg(msg, 0);
        new ExtraTask(this.taskinfo, TaskStatus.STATUS_FAIL).runAndWait();
        this.parent.getScheduler().finishedTask(this, this.taskinfo, TaskStatus.STATUS_FAIL);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Task other = (Task)obj;
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        if (this.taskinfo == null ? other.taskinfo != null : !this.taskinfo.equals(other.taskinfo)) {
            return false;
        }
        return this.timeout == other.timeout;
    }

    public System getParent() {
        return this.parent;
    }

    public TaskInfo getTaskinfo() {
        return this.taskinfo;
    }

    public long getTime() {
        return this.time;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public boolean isDone() {
        return this.done;
    }

    public Process getProcess() {
        return this.process;
    }
}

